/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.urbanairship.android.layout.event.FormEvent;
import com.urbanairship.android.layout.event.ReportingEvent;
import com.urbanairship.android.layout.model.BaseFormController;
import com.urbanairship.android.layout.model.BaseModel;
import com.urbanairship.android.layout.property.FormBehaviorType;
import com.urbanairship.android.layout.property.ViewType;
import com.urbanairship.android.layout.reporting.FormData;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonMap;

public class NpsFormController
extends BaseFormController {
    @NonNull
    private final String scoreIdentifier;

    public NpsFormController(@NonNull String identifier, @NonNull String responseType, @NonNull String scoreIdentifier, @NonNull BaseModel view, @Nullable FormBehaviorType submitBehavior) {
        super(ViewType.NPS_FORM_CONTROLLER, identifier, responseType, view, submitBehavior);
        this.scoreIdentifier = scoreIdentifier;
    }

    @NonNull
    public static NpsFormController fromJson(@NonNull JsonMap json) throws JsonException {
        String identifier = NpsFormController.identifierFromJson(json);
        String scoreIdentifier = json.opt("nps_identifier").optString();
        String responseType = json.opt("response_type").getString();
        BaseModel view = NpsFormController.viewFromJson(json);
        FormBehaviorType submitBehavior = NpsFormController.submitBehaviorFromJson(json);
        return new NpsFormController(identifier, responseType, scoreIdentifier, view, submitBehavior);
    }

    @NonNull
    public String getScoreIdentifier() {
        return this.scoreIdentifier;
    }

    @Override
    protected ReportingEvent.FormResult getFormResultEvent() {
        return new ReportingEvent.FormResult(new FormData.Nps(this.getIdentifier(), this.getResponseType(), this.getScoreIdentifier(), this.getFormData()), this.getFormInfo(), this.getAttributes());
    }

    @Override
    protected FormEvent.Init getInitEvent() {
        return new FormEvent.Init(this.getIdentifier(), this.isFormValid());
    }

    @Override
    protected FormEvent.DataChange getFormDataChangeEvent() {
        return new FormEvent.DataChange(new FormData.Nps(this.getIdentifier(), this.getResponseType(), this.getScoreIdentifier(), this.getFormData()), this.isFormValid(), this.getAttributes());
    }

    @Override
    @NonNull
    protected String getFormType() {
        return "nps";
    }
}

