/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.urbanairship.Logger;
import com.urbanairship.android.layout.Thomas;
import com.urbanairship.android.layout.event.Event;
import com.urbanairship.android.layout.event.PagerEvent;
import com.urbanairship.android.layout.event.ReportingEvent;
import com.urbanairship.android.layout.model.BaseModel;
import com.urbanairship.android.layout.model.Identifiable;
import com.urbanairship.android.layout.model.LayoutModel;
import com.urbanairship.android.layout.property.ViewType;
import com.urbanairship.android.layout.reporting.LayoutData;
import com.urbanairship.android.layout.reporting.PagerData;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonMap;
import java.util.Collections;
import java.util.List;

public class PagerController
extends LayoutModel
implements Identifiable {
    @NonNull
    private final BaseModel view;
    @NonNull
    private final String identifier;
    private String pageIdentifier;
    private int pageIndex = -1;
    private int count = -1;
    private boolean completed = false;

    public PagerController(@NonNull BaseModel view, @NonNull String identifier) {
        super(ViewType.PAGER_CONTROLLER, null, null);
        this.view = view;
        this.identifier = identifier;
        view.addListener(this);
    }

    @NonNull
    public static PagerController fromJson(@NonNull JsonMap json) throws JsonException {
        JsonMap viewJson = json.opt("view").optMap();
        BaseModel view = Thomas.model(viewJson);
        String identifier = Identifiable.identifierFromJson(json);
        return new PagerController(view, identifier);
    }

    @Override
    public List<BaseModel> getChildren() {
        return Collections.singletonList(this.view);
    }

    @NonNull
    public BaseModel getView() {
        return this.view;
    }

    @Override
    @NonNull
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public boolean onEvent(@NonNull Event event, @Nullable LayoutData layoutData) {
        Logger.verbose((String)"onEvent: %s", (Object[])new Object[]{event});
        LayoutData override = layoutData.withPagerData(this.buildPagerData());
        switch (event.getType()) {
            case PAGER_INIT: {
                PagerEvent.Init init = (PagerEvent.Init)event;
                boolean isReinit = this.isInitialized();
                this.trickleEvent(init, override);
                this.reducePagerState(init);
                if (!isReinit) {
                    this.reportPageView(init);
                    this.handlePageActions(init);
                }
                return true;
            }
            case PAGER_SCROLL: {
                PagerEvent.Scroll scroll = (PagerEvent.Scroll)event;
                if (!scroll.isInternal()) {
                    this.reportPageSwipe(scroll);
                }
                this.handlePageActions(scroll);
                this.trickleEvent(scroll, override);
                this.reducePagerState(scroll);
                this.reportPageView(scroll);
                return true;
            }
            case BUTTON_BEHAVIOR_PAGER_NEXT: 
            case BUTTON_BEHAVIOR_PAGER_PREVIOUS: {
                this.trickleEvent(event, override);
                return false;
            }
            case VIEW_INIT: {
                if (((Event.ViewInit)event).getViewType() == ViewType.PAGER_INDICATOR) {
                    return true;
                }
                return super.onEvent(event, override);
            }
        }
        return super.onEvent(event, override);
    }

    private void reducePagerState(PagerEvent event) {
        switch (event.getType()) {
            case PAGER_INIT: {
                PagerEvent.Init init = (PagerEvent.Init)event;
                this.count = init.getSize();
                this.pageIndex = init.getPageIndex();
                this.pageIdentifier = init.getPageId();
                this.completed = this.count == 1;
                break;
            }
            case PAGER_SCROLL: {
                PagerEvent.Scroll scroll = (PagerEvent.Scroll)event;
                this.pageIndex = scroll.getPageIndex();
                this.pageIdentifier = scroll.getPageId();
                this.completed = this.completed || this.pageIndex == this.count - 1;
            }
        }
    }

    private void reportPageView(PagerEvent event) {
        PagerData pagerData = this.buildPagerData();
        this.bubbleEvent(new ReportingEvent.PageView(pagerData, event.getTime()), LayoutData.pager(pagerData));
    }

    private void reportPageSwipe(PagerEvent.Scroll event) {
        PagerData data = this.buildPagerData();
        this.bubbleEvent(new ReportingEvent.PageSwipe(data, event.getPreviousPageIndex(), event.getPreviousPageId(), event.getPageIndex(), event.getPageId()), LayoutData.pager(data));
    }

    private void handlePageActions(PagerEvent event) {
        if (event.hasPageActions()) {
            this.bubbleEvent(new PagerEvent.PageActions(event.getPageActions()), LayoutData.pager(this.buildPagerData()));
        }
    }

    @NonNull
    private PagerData buildPagerData() {
        String pageId = this.pageIdentifier == null ? "" : this.pageIdentifier;
        return new PagerData(this.identifier, this.pageIndex, pageId, this.count, this.completed);
    }

    private boolean isInitialized() {
        return this.pageIdentifier != null && this.pageIndex != -1 && this.count != -1;
    }
}

