/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.model;

import android.view.View;
import androidx.annotation.Dimension;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.urbanairship.Logger;
import com.urbanairship.android.layout.event.Event;
import com.urbanairship.android.layout.event.PagerEvent;
import com.urbanairship.android.layout.model.BaseModel;
import com.urbanairship.android.layout.property.Border;
import com.urbanairship.android.layout.property.Color;
import com.urbanairship.android.layout.property.Image;
import com.urbanairship.android.layout.property.ViewType;
import com.urbanairship.android.layout.reporting.LayoutData;
import com.urbanairship.android.layout.shape.Shape;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonList;
import com.urbanairship.json.JsonMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class PagerIndicatorModel
extends BaseModel {
    @NonNull
    private final Bindings bindings;
    private final int indicatorSpacing;
    private int size = -1;
    private int position = -1;
    @Nullable
    private Listener listener;
    private final HashMap<Integer, Integer> indicatorViewIds = new HashMap();

    public PagerIndicatorModel(@NonNull Bindings bindings, int indicatorSpacing, @Nullable Color backgroundColor, @Nullable Border border) {
        super(ViewType.PAGER_INDICATOR, backgroundColor, border);
        this.bindings = bindings;
        this.indicatorSpacing = indicatorSpacing;
    }

    @NonNull
    public static PagerIndicatorModel fromJson(@NonNull JsonMap json) throws JsonException {
        JsonMap bindingsJson = json.opt("bindings").optMap();
        Bindings bindings = Bindings.fromJson(bindingsJson);
        int indicatorSpacing = json.opt("spacing").getInt(4);
        Border border = PagerIndicatorModel.borderFromJson(json);
        Color backgroundColor = PagerIndicatorModel.backgroundColorFromJson(json);
        return new PagerIndicatorModel(bindings, indicatorSpacing, backgroundColor, border);
    }

    public int getIndicatorViewId(int position) {
        Integer viewId = null;
        if (this.indicatorViewIds.containsKey(position)) {
            viewId = this.indicatorViewIds.get(position);
        }
        if (viewId == null) {
            viewId = View.generateViewId();
            this.indicatorViewIds.put(position, viewId);
        }
        return viewId;
    }

    @NonNull
    public Bindings getBindings() {
        return this.bindings;
    }

    @Dimension(unit=0)
    public int getIndicatorSpacing() {
        return this.indicatorSpacing;
    }

    public int getSize() {
        return this.size;
    }

    public int getPosition() {
        return this.position;
    }

    public void setListener(@Nullable Listener listener) {
        this.listener = listener;
        if (listener != null && this.size != -1 && this.position != -1) {
            listener.onInit(this.size, this.position);
        }
    }

    public void onConfigured() {
        this.bubbleEvent(new PagerEvent.IndicatorInit(this), LayoutData.empty());
    }

    @Override
    public boolean onEvent(@NonNull Event event, @NonNull LayoutData layoutData) {
        Logger.verbose((String)"onEvent: %s layoutData: %s", (Object[])new Object[]{event, layoutData});
        switch (event.getType()) {
            case PAGER_INIT: {
                if (!this.onPagerInit((PagerEvent.Init)event)) break;
                return true;
            }
            case PAGER_SCROLL: {
                if (!this.onPagerScroll((PagerEvent.Scroll)event)) break;
                return true;
            }
        }
        return super.onEvent(event, layoutData);
    }

    private boolean onPagerInit(PagerEvent.Init event) {
        this.size = event.getSize();
        this.position = event.getPageIndex();
        if (this.listener != null) {
            this.listener.onInit(this.size, this.position);
        }
        return true;
    }

    private boolean onPagerScroll(PagerEvent.Scroll event) {
        this.position = event.getPageIndex();
        if (this.listener != null) {
            this.listener.onUpdate(this.position);
        }
        return true;
    }

    public static interface Listener {
        public void onInit(int var1, int var2);

        public void onUpdate(int var1);
    }

    public static class Binding {
        @NonNull
        private final List<Shape> shapes;
        @Nullable
        private final Image.Icon icon;

        public Binding(@NonNull List<Shape> shapes, @Nullable Image.Icon icon) {
            this.shapes = shapes;
            this.icon = icon;
        }

        @NonNull
        public static Binding fromJson(@NonNull JsonMap json) throws JsonException {
            JsonList shapesJson = json.opt("shapes").optList();
            JsonMap iconJson = json.opt("icon").optMap();
            ArrayList<Shape> shapes = new ArrayList<Shape>();
            for (int i = 0; i < shapesJson.size(); ++i) {
                JsonMap shapeJson = shapesJson.get(i).optMap();
                Shape shape = Shape.fromJson(shapeJson);
                shapes.add(shape);
            }
            Image.Icon icon = iconJson.isEmpty() ? null : Image.Icon.fromJson(iconJson);
            return new Binding(shapes, icon);
        }

        @NonNull
        public List<Shape> getShapes() {
            return this.shapes;
        }

        @Nullable
        public Image.Icon getIcon() {
            return this.icon;
        }
    }

    public static class Bindings {
        @NonNull
        private final Binding selected;
        @NonNull
        private final Binding unselected;

        Bindings(@NonNull Binding selected, @NonNull Binding unselected) {
            this.selected = selected;
            this.unselected = unselected;
        }

        public static Bindings fromJson(@NonNull JsonMap json) throws JsonException {
            JsonMap selectedJson = json.opt("selected").optMap();
            JsonMap unselectedJson = json.opt("unselected").optMap();
            Binding selected = Binding.fromJson(selectedJson);
            Binding unselected = Binding.fromJson(unselectedJson);
            return new Bindings(selected, unselected);
        }

        @NonNull
        public Binding getSelected() {
            return this.selected;
        }

        @NonNull
        public Binding getUnselected() {
            return this.unselected;
        }
    }
}

