/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.urbanairship.android.layout.event.Event;
import com.urbanairship.android.layout.event.RadioEvent;
import com.urbanairship.android.layout.model.Accessible;
import com.urbanairship.android.layout.model.CheckableModel;
import com.urbanairship.android.layout.property.Border;
import com.urbanairship.android.layout.property.Color;
import com.urbanairship.android.layout.property.ToggleStyle;
import com.urbanairship.android.layout.property.ViewType;
import com.urbanairship.android.layout.reporting.LayoutData;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonMap;
import com.urbanairship.json.JsonValue;

public class RadioInputModel
extends CheckableModel {
    @NonNull
    private final JsonValue reportingValue;
    @NonNull
    private final JsonValue attributeValue;

    public RadioInputModel(@NonNull ToggleStyle style, @NonNull JsonValue reportingValue, @NonNull JsonValue attributeValue, @Nullable String contentDescription, @Nullable Color backgroundColor, @Nullable Border border) {
        super(ViewType.RADIO_INPUT, style, contentDescription, backgroundColor, border);
        this.reportingValue = reportingValue;
        this.attributeValue = attributeValue;
    }

    @NonNull
    public static RadioInputModel fromJson(@NonNull JsonMap json) throws JsonException {
        ToggleStyle style = RadioInputModel.toggleStyleFromJson(json);
        JsonValue reportingValue = json.opt("reporting_value");
        JsonValue attributeValue = json.opt("attribute_value");
        String contentDescription = Accessible.contentDescriptionFromJson(json);
        Color backgroundColor = RadioInputModel.backgroundColorFromJson(json);
        Border border = RadioInputModel.borderFromJson(json);
        return new RadioInputModel(style, reportingValue, attributeValue, contentDescription, backgroundColor, border);
    }

    @NonNull
    public JsonValue getReportingValue() {
        return this.reportingValue;
    }

    @NonNull
    public JsonValue getAttributeValue() {
        return this.attributeValue;
    }

    @Override
    @NonNull
    public Event buildInputChangeEvent(boolean isChecked) {
        return new RadioEvent.InputChange(this.reportingValue, this.attributeValue, isChecked);
    }

    @Override
    @NonNull
    public Event buildInitEvent() {
        return new Event.ViewInit(this);
    }

    @Override
    public boolean onEvent(@NonNull Event event, @NonNull LayoutData layoutData) {
        switch (event.getType()) {
            case RADIO_VIEW_UPDATE: {
                RadioEvent.ViewUpdate update = (RadioEvent.ViewUpdate)event;
                this.setChecked(this.reportingValue.equals(update.getValue()));
                return false;
            }
        }
        return super.onEvent(event, layoutData);
    }
}

