/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.urbanairship.android.layout.Thomas;
import com.urbanairship.android.layout.model.BaseModel;
import com.urbanairship.android.layout.model.LayoutModel;
import com.urbanairship.android.layout.property.Border;
import com.urbanairship.android.layout.property.Color;
import com.urbanairship.android.layout.property.Direction;
import com.urbanairship.android.layout.property.ViewType;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonMap;
import java.util.Collections;
import java.util.List;

public class ScrollLayoutModel
extends LayoutModel {
    @NonNull
    private final Direction direction;
    @NonNull
    private final BaseModel view;

    public ScrollLayoutModel(@NonNull BaseModel view, @NonNull Direction direction, @Nullable Color backgroundColor, @Nullable Border border) {
        super(ViewType.SCROLL_LAYOUT, backgroundColor, border);
        this.view = view;
        this.direction = direction;
        view.addListener(this);
    }

    @NonNull
    public static ScrollLayoutModel fromJson(@NonNull JsonMap json) throws JsonException {
        JsonMap viewJson = json.opt("view").optMap();
        String directionString = json.opt("direction").optString();
        BaseModel view = Thomas.model(viewJson);
        Direction direction = Direction.from(directionString);
        Color backgroundColor = ScrollLayoutModel.backgroundColorFromJson(json);
        Border border = ScrollLayoutModel.borderFromJson(json);
        return new ScrollLayoutModel(view, direction, backgroundColor, border);
    }

    @NonNull
    public Direction getDirection() {
        return this.direction;
    }

    @NonNull
    public BaseModel getView() {
        return this.view;
    }

    @Override
    @NonNull
    public List<BaseModel> getChildren() {
        return Collections.singletonList(this.view);
    }
}

