/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.model;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.urbanairship.android.layout.event.Event;
import com.urbanairship.android.layout.event.FormEvent;
import com.urbanairship.android.layout.event.ToggleEvent;
import com.urbanairship.android.layout.model.Accessible;
import com.urbanairship.android.layout.model.BaseModel;
import com.urbanairship.android.layout.model.CheckableModel;
import com.urbanairship.android.layout.model.Identifiable;
import com.urbanairship.android.layout.model.Validatable;
import com.urbanairship.android.layout.property.Border;
import com.urbanairship.android.layout.property.Color;
import com.urbanairship.android.layout.property.ToggleStyle;
import com.urbanairship.android.layout.property.ViewType;
import com.urbanairship.android.layout.reporting.AttributeName;
import com.urbanairship.android.layout.reporting.FormData;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonMap;
import com.urbanairship.json.JsonValue;
import java.util.Objects;

public class ToggleModel
extends CheckableModel
implements Identifiable,
Validatable {
    @NonNull
    private final String identifier;
    private final boolean isRequired;
    @Nullable
    private final AttributeName attributeName;
    @Nullable
    private final JsonValue attributeValue;
    @Nullable
    private Boolean value = null;

    public ToggleModel(@NonNull String identifier, @NonNull ToggleStyle style, @Nullable AttributeName attributeName, @Nullable JsonValue attributeValue, @Nullable String contentDescription, boolean isRequired, @Nullable Color backgroundColor, @Nullable Border border) {
        super(ViewType.TOGGLE, style, contentDescription, backgroundColor, border);
        this.attributeName = attributeName;
        this.attributeValue = attributeValue;
        this.identifier = identifier;
        this.isRequired = isRequired;
    }

    @NonNull
    public static ToggleModel fromJson(@NonNull JsonMap json) throws JsonException {
        ToggleStyle toggleStyle = ToggleModel.toggleStyleFromJson(json);
        AttributeName attributeName = AttributeName.attributeNameFromJson(json);
        JsonValue attributeValue = json.opt("attribute_value");
        String identifier = Identifiable.identifierFromJson(json);
        String contentDescription = Accessible.contentDescriptionFromJson(json);
        boolean required = Validatable.requiredFromJson(json);
        Color backgroundColor = ToggleModel.backgroundColorFromJson(json);
        Border border = ToggleModel.borderFromJson(json);
        return new ToggleModel(identifier, toggleStyle, attributeName, attributeValue, contentDescription, required, backgroundColor, border);
    }

    @NonNull
    public BaseModel getView() {
        return this;
    }

    @Override
    @NonNull
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public boolean isRequired() {
        return this.isRequired;
    }

    @Override
    public boolean isValid() {
        return Objects.equals(this.value, true) || !this.isRequired;
    }

    @Override
    @NonNull
    public Event buildInputChangeEvent(boolean isChecked) {
        return new FormEvent.DataChange(new FormData.Toggle(this.identifier, isChecked), this.isValid(), this.attributeName, this.attributeValue);
    }

    @Override
    @NonNull
    public Event buildInitEvent() {
        return new ToggleEvent.Init(this.identifier, this.isValid());
    }

    @Override
    public void onCheckedChange(boolean isChecked) {
        this.value = isChecked;
        super.onCheckedChange(isChecked);
    }
}

