/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.model;

import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.urbanairship.android.layout.event.WebViewEvent;
import com.urbanairship.android.layout.model.BaseModel;
import com.urbanairship.android.layout.property.Border;
import com.urbanairship.android.layout.property.Color;
import com.urbanairship.android.layout.property.ViewType;
import com.urbanairship.android.layout.reporting.LayoutData;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonMap;

public class WebViewModel
extends BaseModel {
    @NonNull
    private final String url;
    @Nullable
    private Bundle savedState;

    public WebViewModel(@NonNull String url, @Nullable Color backgroundColor, @Nullable Border border) {
        super(ViewType.WEB_VIEW, backgroundColor, border);
        this.url = url;
    }

    @NonNull
    public static WebViewModel fromJson(@NonNull JsonMap json) throws JsonException {
        String url = json.opt("url").optString();
        Color backgroundColor = WebViewModel.backgroundColorFromJson(json);
        Border border = WebViewModel.borderFromJson(json);
        return new WebViewModel(url, backgroundColor, border);
    }

    @NonNull
    public String getUrl() {
        return this.url;
    }

    public void onClose() {
        this.bubbleEvent(new WebViewEvent.Close(), LayoutData.empty());
    }

    public void saveState(@NonNull Bundle bundle) {
        this.savedState = bundle;
    }

    @Nullable
    public Bundle getSavedState() {
        return this.savedState;
    }
}

