/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.property;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.urbanairship.android.layout.model.SafeAreaAware;
import com.urbanairship.android.layout.property.ConstrainedSize;
import com.urbanairship.android.layout.property.Margin;
import com.urbanairship.android.layout.property.Position;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonMap;

public class BannerPlacement
implements SafeAreaAware {
    @NonNull
    private final ConstrainedSize size;
    @Nullable
    private final Margin margin;
    @Nullable
    private final Position position;
    private final boolean ignoreSafeArea;

    public BannerPlacement(@NonNull ConstrainedSize size, @Nullable Margin margin, @Nullable Position position, boolean ignoreSafeArea) {
        this.size = size;
        this.margin = margin;
        this.position = position;
        this.ignoreSafeArea = ignoreSafeArea;
    }

    @NonNull
    public static BannerPlacement fromJson(@NonNull JsonMap json) throws JsonException {
        JsonMap sizeJson = json.opt("size").optMap();
        if (sizeJson.isEmpty()) {
            throw new JsonException("Failed to parse Modal Placement! Field 'size' is required.");
        }
        JsonMap positionJson = json.opt("position").optMap();
        JsonMap marginJson = json.opt("margin").optMap();
        ConstrainedSize size = ConstrainedSize.fromJson(sizeJson);
        Margin margin = marginJson.isEmpty() ? null : Margin.fromJson(marginJson);
        Position position = positionJson.isEmpty() ? null : Position.fromJson(positionJson);
        boolean ignoreSafeArea = SafeAreaAware.ignoreSafeAreaFromJson(json);
        return new BannerPlacement(size, margin, position, ignoreSafeArea);
    }

    @Nullable
    public Margin getMargin() {
        return this.margin;
    }

    @NonNull
    public ConstrainedSize getSize() {
        return this.size;
    }

    @Nullable
    public Position getPosition() {
        return this.position;
    }

    @Override
    public boolean shouldIgnoreSafeArea() {
        return this.ignoreSafeArea;
    }
}

