/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.property;

import androidx.annotation.NonNull;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonList;
import com.urbanairship.json.JsonValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public enum ButtonClickBehaviorType {
    FORM_SUBMIT("form_submit"),
    PAGER_NEXT("pager_next"),
    PAGER_PREVIOUS("pager_previous"),
    DISMISS("dismiss"),
    CANCEL("cancel");

    @NonNull
    private final String value;

    private ButtonClickBehaviorType(String value) {
        this.value = value;
    }

    @NonNull
    public static ButtonClickBehaviorType from(@NonNull String value) throws JsonException {
        for (ButtonClickBehaviorType type : ButtonClickBehaviorType.values()) {
            if (!type.value.equals(value.toLowerCase(Locale.ROOT))) continue;
            return type;
        }
        throw new JsonException("Unknown ButtonClickBehaviorType value: " + value);
    }

    @NonNull
    public static List<ButtonClickBehaviorType> fromList(@NonNull JsonList json) throws JsonException {
        if (json.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ButtonClickBehaviorType> behaviorTypes = new ArrayList<ButtonClickBehaviorType>(json.size());
        for (JsonValue value : json) {
            behaviorTypes.add(ButtonClickBehaviorType.from(value.optString()));
        }
        Collections.sort(behaviorTypes, Enum::compareTo);
        return behaviorTypes;
    }

    @NonNull
    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }
}

