/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.property;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.urbanairship.android.layout.property.Size;
import com.urbanairship.android.layout.util.PercentUtils;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonMap;

public class ConstrainedSize
extends Size {
    @Nullable
    private final ConstrainedDimension minWidth;
    @Nullable
    private final ConstrainedDimension minHeight;
    @Nullable
    private final ConstrainedDimension maxWidth;
    @Nullable
    private final ConstrainedDimension maxHeight;

    public ConstrainedSize(@NonNull String width, @NonNull String height, @Nullable String minWidth, @Nullable String minHeight, @Nullable String maxWidth, @Nullable String maxHeight) {
        super(width, height);
        this.minWidth = ConstrainedDimension.of(minWidth);
        this.minHeight = ConstrainedDimension.of(minHeight);
        this.maxWidth = ConstrainedDimension.of(maxWidth);
        this.maxHeight = ConstrainedDimension.of(maxHeight);
    }

    @NonNull
    public static ConstrainedSize fromJson(@NonNull JsonMap json) throws JsonException {
        String width = json.opt("width").coerceString();
        String height = json.opt("height").coerceString();
        if (width == null || height == null) {
            throw new JsonException("Size requires both width and height!");
        }
        String minWidth = json.opt("min_width").coerceString();
        String minHeight = json.opt("min_height").coerceString();
        String maxWidth = json.opt("max_width").coerceString();
        String maxHeight = json.opt("max_height").coerceString();
        return new ConstrainedSize(width, height, minWidth, minHeight, maxWidth, maxHeight);
    }

    @Override
    @NonNull
    public String toString() {
        return "ConstrainedSize { width=" + this.getWidth() + ", height=" + this.getHeight() + ", minWidth=" + this.getMinWidth() + ", minHeight=" + this.getMinHeight() + ", maxWidth=" + this.getMaxWidth() + ", maxHeight=" + this.getMaxHeight() + " }";
    }

    @Nullable
    public ConstrainedDimension getMinWidth() {
        return this.minWidth;
    }

    @Nullable
    public ConstrainedDimension getMinHeight() {
        return this.minHeight;
    }

    @Nullable
    public ConstrainedDimension getMaxWidth() {
        return this.maxWidth;
    }

    @Nullable
    public ConstrainedDimension getMaxHeight() {
        return this.maxHeight;
    }

    public static class AbsoluteConstrainedDimension
    extends ConstrainedDimension {
        AbsoluteConstrainedDimension(@NonNull String value) {
            super(value, ConstrainedDimensionType.ABSOLUTE);
        }

        @Override
        public float getFloat() {
            return Float.parseFloat(this.value);
        }

        @Override
        public int getInt() {
            return Integer.parseInt(this.value);
        }

        @NonNull
        public String toString() {
            return this.getInt() + "dp";
        }
    }

    public static class PercentConstrainedDimension
    extends ConstrainedDimension {
        PercentConstrainedDimension(@NonNull String value) {
            super(value, ConstrainedDimensionType.PERCENT);
        }

        @Override
        public float getFloat() {
            return PercentUtils.parse(this.value);
        }

        @Override
        public int getInt() {
            return (int)this.getFloat();
        }

        @NonNull
        public String toString() {
            return (int)(this.getFloat() * 100.0f) + "%";
        }
    }

    public static abstract class ConstrainedDimension {
        @NonNull
        protected final String value;
        @NonNull
        private final ConstrainedDimensionType type;

        ConstrainedDimension(@NonNull String value, @NonNull ConstrainedDimensionType type) {
            this.value = value;
            this.type = type;
        }

        @Nullable
        public static ConstrainedDimension of(@Nullable String value) {
            if (value == null) {
                return null;
            }
            if (PercentUtils.isPercent(value)) {
                return new PercentConstrainedDimension(value);
            }
            return new AbsoluteConstrainedDimension(value);
        }

        public abstract float getFloat();

        public abstract int getInt();

        @NonNull
        public ConstrainedDimensionType getType() {
            return this.type;
        }

        public boolean isPercent() {
            return this.type == ConstrainedDimensionType.PERCENT;
        }

        public boolean isAbsolute() {
            return this.type == ConstrainedDimensionType.ABSOLUTE;
        }
    }

    public static enum ConstrainedDimensionType {
        PERCENT,
        ABSOLUTE;

    }
}

