/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.property;

import androidx.annotation.NonNull;
import com.urbanairship.json.JsonException;
import java.util.Locale;

public enum FormInputType {
    EMAIL("email", 33),
    NUMBER("number", 2),
    TEXT("text", 49153),
    TEXT_MULTILINE("text_multiline", 180225);

    @NonNull
    private final String value;
    private final int typeMask;

    private FormInputType(String value, int typeMask) {
        this.value = value;
        this.typeMask = typeMask;
    }

    @NonNull
    public static FormInputType from(@NonNull String value) throws JsonException {
        for (FormInputType type : FormInputType.values()) {
            if (!type.value.equals(value.toLowerCase(Locale.ROOT))) continue;
            return type;
        }
        throw new JsonException("Unknown Form Input Type value: " + value);
    }

    public int getTypeMask() {
        return this.typeMask;
    }

    @NonNull
    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }
}

