/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.property;

import android.graphics.Color;
import androidx.annotation.ColorInt;
import androidx.annotation.Nullable;
import androidx.core.graphics.ColorUtils;
import com.urbanairship.Logger;
import com.urbanairship.json.JsonMap;

public final class HexColor {
    private HexColor() {
    }

    @Nullable
    @ColorInt
    public static Integer fromJson(@Nullable JsonMap json) {
        if (json == null || json.isEmpty()) {
            return null;
        }
        String hex = json.opt("hex").optString();
        float alpha = json.opt("alpha").getFloat(1.0f);
        if (hex.isEmpty() || alpha > 1.0f || alpha < 0.0f) {
            Logger.warn((String)"Invalid Color json: %s", (Object[])new Object[]{json.toString()});
            return null;
        }
        int color = Color.parseColor((String)hex);
        if (alpha != 1.0f) {
            color = ColorUtils.setAlphaComponent((int)color, (int)((int)(alpha * 255.0f)));
        }
        return color;
    }
}

