/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.property;

import android.content.Context;
import android.graphics.drawable.Drawable;
import androidx.annotation.DrawableRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import com.urbanairship.android.layout.R;
import com.urbanairship.android.layout.property.Color;
import com.urbanairship.android.layout.widget.ShapeDrawableWrapper;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonMap;
import java.util.Locale;

public abstract class Image {
    @NonNull
    private final Type type;

    private Image(@NonNull Type type) {
        this.type = type;
    }

    @NonNull
    public static Image fromJson(@NonNull JsonMap json) throws JsonException {
        String typeString = json.opt("type").optString();
        switch (Type.from(typeString)) {
            case URL: {
                return Url.fromJson(json);
            }
            case ICON: {
                return Icon.fromJson(json);
            }
        }
        throw new JsonException("Failed to parse image! Unknown button image type value: " + typeString);
    }

    @NonNull
    public Type getType() {
        return this.type;
    }

    public static final class Icon
    extends Image {
        @NonNull
        private final DrawableResource drawable;
        @NonNull
        private final Color tint;
        private final float scale;

        public Icon(@NonNull DrawableResource drawable2, @NonNull Color tint, float scale) {
            super(Type.ICON);
            this.drawable = drawable2;
            this.tint = tint;
            this.scale = scale;
        }

        @NonNull
        public static Icon fromJson(@NonNull JsonMap json) throws JsonException {
            String iconString = json.opt("icon").optString();
            DrawableResource icon = DrawableResource.from(iconString);
            Color tint = Color.fromJsonField(json, "color");
            if (tint == null) {
                throw new JsonException("Failed to parse icon! Field 'color' is required.");
            }
            float scale = json.opt("scale").getFloat(1.0f);
            return new Icon(icon, tint, scale);
        }

        @DrawableRes
        public int getDrawableRes() {
            return this.drawable.resId;
        }

        @Nullable
        public Drawable getDrawable(@NonNull Context context) {
            Drawable d = ContextCompat.getDrawable((Context)context, (int)this.getDrawableRes());
            if (d != null) {
                DrawableCompat.setTint((Drawable)d, (int)this.tint.resolve(context));
                return new ShapeDrawableWrapper(d, 1.0f, this.scale);
            }
            return null;
        }

        @NonNull
        public Color getTint() {
            return this.tint;
        }

        public float getScale() {
            return this.scale;
        }

        private static enum DrawableResource {
            CLOSE("close", R.drawable.ua_layout_ic_close),
            CHECKMARK("checkmark", R.drawable.ua_layout_ic_check),
            ARROW_FORWARD("forward_arrow", R.drawable.ua_layout_ic_arrow_forward),
            ARROW_BACK("back_arrow", R.drawable.ua_layout_ic_arrow_back);

            @NonNull
            private final String value;
            @DrawableRes
            private final int resId;

            private DrawableResource(String value, int resId) {
                this.value = value;
                this.resId = resId;
            }

            @NonNull
            private static DrawableResource from(String value) throws JsonException {
                for (DrawableResource res : DrawableResource.values()) {
                    if (!res.value.equals(value.toLowerCase(Locale.ROOT))) continue;
                    return res;
                }
                throw new JsonException("Unknown icon drawable resource: " + value);
            }
        }
    }

    public static final class Url
    extends Image {
        @NonNull
        private final String url;

        public Url(@NonNull String url) {
            super(Type.URL);
            this.url = url;
        }

        @NonNull
        public static Url fromJson(@NonNull JsonMap json) {
            String url = json.opt("url").optString();
            return new Url(url);
        }

        @NonNull
        public String getUrl() {
            return this.url;
        }
    }

    public static enum Type {
        URL("url"),
        ICON("icon");

        @NonNull
        private final String value;

        private Type(String value) {
            this.value = value;
        }

        @NonNull
        public static Type from(@NonNull String value) throws JsonException {
            for (Type type : Type.values()) {
                if (!type.value.equals(value.toLowerCase(Locale.ROOT))) continue;
                return type;
            }
            throw new JsonException("Unknown button image type value: " + value);
        }
    }
}

