/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.property;

import androidx.annotation.NonNull;
import com.urbanairship.android.layout.property.HorizontalPosition;
import com.urbanairship.android.layout.property.VerticalPosition;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonMap;

public class Position {
    @NonNull
    private final HorizontalPosition horizontal;
    @NonNull
    private final VerticalPosition vertical;

    public Position(@NonNull HorizontalPosition horizontal, @NonNull VerticalPosition vertical) {
        this.horizontal = horizontal;
        this.vertical = vertical;
    }

    @NonNull
    public static Position fromJson(@NonNull JsonMap json) throws JsonException {
        String horizontalJson = json.opt("horizontal").optString();
        String verticalJson = json.opt("vertical").optString();
        HorizontalPosition horizontal = HorizontalPosition.from(horizontalJson);
        VerticalPosition vertical = VerticalPosition.from(verticalJson);
        return new Position(horizontal, vertical);
    }

    @NonNull
    public HorizontalPosition getHorizontal() {
        return this.horizontal;
    }

    @NonNull
    public VerticalPosition getVertical() {
        return this.vertical;
    }

    public int getGravity() {
        return 0x11 | this.horizontal.getGravity() | this.vertical.getGravity();
    }
}

