/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.property;

import androidx.annotation.NonNull;
import com.urbanairship.android.layout.property.Color;
import com.urbanairship.android.layout.property.ToggleStyle;
import com.urbanairship.android.layout.property.ToggleType;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonMap;

public class SwitchStyle
extends ToggleStyle {
    @NonNull
    private final Color onColor;
    @NonNull
    private final Color offColor;

    public SwitchStyle(@NonNull Color onColor, @NonNull Color offColor) {
        super(ToggleType.SWITCH);
        this.onColor = onColor;
        this.offColor = offColor;
    }

    @NonNull
    public static SwitchStyle fromJson(@NonNull JsonMap json) throws JsonException {
        JsonMap colors = json.opt("toggle_colors").optMap();
        Color onColor = Color.fromJsonField(colors, "on");
        if (onColor == null) {
            throw new JsonException("Failed to parse SwitchStyle! Field 'toggle_colors.on' may not be null.");
        }
        Color offColor = Color.fromJsonField(colors, "off");
        if (offColor == null) {
            throw new JsonException("Failed to parse SwitchStyle! Field 'toggle_colors.off' may not be null.");
        }
        return new SwitchStyle(onColor, offColor);
    }

    @NonNull
    public Color getOnColor() {
        return this.onColor;
    }

    @NonNull
    public Color getOffColor() {
        return this.offColor;
    }
}

