/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.reporting;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.util.ObjectsCompat;
import com.urbanairship.json.JsonMap;
import com.urbanairship.util.UAStringUtil;

public class AttributeName {
    @Nullable
    private final String channel;
    @Nullable
    private final String contact;

    public AttributeName(@Nullable String channel, @Nullable String contact) {
        this.channel = channel;
        this.contact = contact;
    }

    @Nullable
    public static AttributeName fromJson(@NonNull JsonMap json) {
        String channel = json.opt("channel").getString();
        String contact = json.opt("contact").getString();
        if (channel != null || contact != null) {
            return new AttributeName(channel, contact);
        }
        return null;
    }

    @Nullable
    public static AttributeName attributeNameFromJson(@NonNull JsonMap json) {
        JsonMap attributeNameJson = json.opt("attribute_name").optMap();
        return AttributeName.fromJson(attributeNameJson);
    }

    @Nullable
    public String getChannel() {
        return this.channel;
    }

    @Nullable
    public String getContact() {
        return this.contact;
    }

    public boolean isChannel() {
        return !UAStringUtil.isEmpty((String)this.channel);
    }

    public boolean isContact() {
        return !UAStringUtil.isEmpty((String)this.contact);
    }

    @NonNull
    public String toString() {
        return "AttributeName{channel='" + this.channel + '\'' + ", contact='" + this.contact + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AttributeName that = (AttributeName)o;
        return ObjectsCompat.equals((Object)this.channel, (Object)that.channel) && ObjectsCompat.equals((Object)this.contact, (Object)that.contact);
    }

    public int hashCode() {
        return ObjectsCompat.hash((Object[])new Object[]{this.channel, this.contact});
    }
}

