/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.reporting;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import com.urbanairship.Logger;
import java.lang.ref.WeakReference;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class DisplayTimer {
    private long resumeTime = 0L;
    private long displayTime = 0L;

    public DisplayTimer(LifecycleOwner lifecycleOwner) {
        this(lifecycleOwner, 0L);
    }

    public DisplayTimer(LifecycleOwner lifecycleOwner, long restoredDisplayTime) {
        if (restoredDisplayTime > 0L) {
            this.displayTime = restoredDisplayTime;
        }
        lifecycleOwner.getLifecycle().addObserver((LifecycleObserver)new LifecycleListener(this));
    }

    public long getTime() {
        long time = this.displayTime;
        if (this.resumeTime > 0L) {
            time += System.currentTimeMillis() - this.resumeTime;
        }
        return time;
    }

    public void onResume() {
        this.resumeTime = System.currentTimeMillis();
    }

    public void onPause() {
        this.displayTime += System.currentTimeMillis() - this.resumeTime;
        this.resumeTime = 0L;
    }

    private static final class LifecycleListener
    implements DefaultLifecycleObserver {
        private final WeakReference<DisplayTimer> weakTimer;

        public LifecycleListener(DisplayTimer timer) {
            this.weakTimer = new WeakReference<DisplayTimer>(timer);
        }

        public void onResume(@NonNull LifecycleOwner owner) {
            DisplayTimer timer = (DisplayTimer)this.weakTimer.get();
            if (timer != null) {
                timer.onResume();
            } else {
                Logger.warn((String)"DisplayTimer ref was null!", (Object[])new Object[0]);
            }
        }

        public void onPause(@NonNull LifecycleOwner owner) {
            DisplayTimer timer = (DisplayTimer)this.weakTimer.get();
            if (timer != null) {
                ((DisplayTimer)this.weakTimer.get()).onPause();
            } else {
                Logger.warn((String)"DisplayTimer ref was null!", (Object[])new Object[0]);
            }
        }

        public void onDestroy(@NonNull LifecycleOwner owner) {
            owner.getLifecycle().removeObserver((LifecycleObserver)this);
        }
    }
}

