/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.reporting;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.urbanairship.json.JsonMap;
import com.urbanairship.json.JsonSerializable;
import com.urbanairship.json.JsonValue;
import java.util.Collection;
import java.util.Set;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public abstract class FormData<T> {
    private static final String KEY_TYPE = "type";
    private static final String KEY_VALUE = "value";
    private static final String KEY_SCORE_ID = "score_id";
    private static final String KEY_CHILDREN = "children";
    private static final String KEY_RESPONSE_TYPE = "response_type";
    @NonNull
    private final Type type;
    @NonNull
    private final T value;
    @NonNull
    private final String identifier;

    public FormData(@NonNull String identifier, @NonNull Type type, @NonNull T value) {
        this.identifier = identifier;
        this.type = type;
        this.value = value;
    }

    @NonNull
    public Type getType() {
        return this.type;
    }

    @NonNull
    public T getValue() {
        return this.value;
    }

    @NonNull
    public String getIdentifier() {
        return this.identifier;
    }

    @NonNull
    protected JsonMap getFormData() {
        return JsonMap.newBuilder().put(KEY_TYPE, (JsonSerializable)this.getType()).put(KEY_VALUE, (JsonSerializable)JsonValue.wrapOpt(this.value)).build();
    }

    public static class Nps
    extends BaseForm {
        private final String scoreId;

        public Nps(@NonNull String identifier, @Nullable String responseType, @NonNull String scoreId, @NonNull Collection<FormData<?>> children) {
            super(identifier, responseType, Type.NPS_FORM, children);
            this.scoreId = scoreId;
        }

        public String getScoreId() {
            return this.scoreId;
        }

        @Override
        @NonNull
        protected JsonMap getFormData() {
            return JsonMap.newBuilder().put(FormData.KEY_TYPE, (JsonSerializable)this.getType()).put(FormData.KEY_CHILDREN, this.getChildrenJson()).put(FormData.KEY_SCORE_ID, this.scoreId).put(FormData.KEY_RESPONSE_TYPE, this.responseType).build();
        }
    }

    public static class Form
    extends BaseForm {
        public Form(@NonNull String identifier, @Nullable String responseType, @NonNull Collection<FormData<?>> children) {
            super(identifier, responseType, Type.FORM, children);
        }

        @Override
        @NonNull
        protected JsonMap getFormData() {
            return JsonMap.newBuilder().put(FormData.KEY_TYPE, (JsonSerializable)this.getType()).put(FormData.KEY_CHILDREN, this.getChildrenJson()).put(FormData.KEY_RESPONSE_TYPE, this.responseType).build();
        }
    }

    public static abstract class BaseForm
    extends FormData<Collection<FormData<?>>>
    implements JsonSerializable {
        protected final String responseType;

        public BaseForm(@NonNull String identifier, @Nullable String responseType, @NonNull Type type, @NonNull Collection<FormData<?>> children) {
            super(identifier, type, children);
            this.responseType = responseType;
        }

        @NonNull
        protected JsonSerializable getChildrenJson() {
            JsonMap.Builder builder = JsonMap.newBuilder();
            for (FormData child : (Collection)this.getValue()) {
                builder.putOpt(child.identifier, (Object)child.getFormData());
            }
            return builder.build();
        }

        @Override
        @NonNull
        protected abstract JsonMap getFormData();

        @NonNull
        public JsonValue toJsonValue() {
            return JsonMap.newBuilder().put(this.getIdentifier(), (JsonSerializable)this.getFormData()).build().toJsonValue();
        }
    }

    public static class Score
    extends FormData<Integer> {
        public Score(@NonNull String identifier, @NonNull Integer value) {
            super(identifier, Type.SCORE, value);
        }
    }

    public static class TextInput
    extends FormData<String> {
        public TextInput(@NonNull String identifier, @NonNull String value) {
            super(identifier, Type.TEXT, value);
        }
    }

    public static class RadioInputController
    extends FormData<JsonValue> {
        public RadioInputController(@NonNull String identifier, @NonNull JsonValue value) {
            super(identifier, Type.SINGLE_CHOICE, value);
        }
    }

    public static class CheckboxController
    extends FormData<Set<JsonValue>> {
        public CheckboxController(@NonNull String identifier, @NonNull Set<JsonValue> value) {
            super(identifier, Type.MULTIPLE_CHOICE, value);
        }
    }

    public static class Toggle
    extends FormData<Boolean> {
        public Toggle(@NonNull String identifier, boolean value) {
            super(identifier, Type.TOGGLE, value);
        }
    }

    private static enum Type implements JsonSerializable
    {
        FORM("form"),
        NPS_FORM("nps"),
        TOGGLE("toggle"),
        MULTIPLE_CHOICE("multiple_choice"),
        SINGLE_CHOICE("single_choice"),
        TEXT("text_input"),
        SCORE("score");

        @NonNull
        private final String value;

        private Type(String value) {
            this.value = value;
        }

        @NonNull
        public JsonValue toJsonValue() {
            return JsonValue.wrap((String)this.value);
        }
    }
}

