/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.ui;

import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.urbanairship.Logger;
import com.urbanairship.android.layout.ThomasListener;
import com.urbanairship.android.layout.event.Event;
import com.urbanairship.android.layout.event.EventListener;
import com.urbanairship.android.layout.event.ReportingEvent;
import com.urbanairship.android.layout.reporting.LayoutData;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
class ThomasListenerProxy
implements EventListener {
    @NonNull
    private final ThomasListener listener;

    public ThomasListenerProxy(@NonNull ThomasListener listener) {
        this.listener = listener;
    }

    @Override
    public boolean onEvent(@NonNull Event event, @NonNull LayoutData layoutData) {
        Logger.verbose((String)"onEvent: %s layoutData: %s", (Object[])new Object[]{event, layoutData});
        switch (event.getType()) {
            case REPORTING_EVENT: {
                this.onReportingEvent((ReportingEvent)event, layoutData);
                break;
            }
            case BUTTON_ACTIONS: 
            case PAGER_PAGE_ACTIONS: {
                this.onActionsEvent((Event.EventWithActions)((Object)event), layoutData);
                break;
            }
        }
        return false;
    }

    private void onActionsEvent(@NonNull Event.EventWithActions event, @NonNull LayoutData layoutData) {
        this.listener.onRunActions(event.getActions(), layoutData);
    }

    private void onReportingEvent(@NonNull ReportingEvent event, @NonNull LayoutData layoutData) {
        switch (event.getReportType()) {
            case PAGE_VIEW: {
                ReportingEvent.PageView pageView = (ReportingEvent.PageView)event;
                this.listener.onPageView(pageView.getPagerData(), layoutData, pageView.getDisplayedAt());
                break;
            }
            case PAGE_SWIPE: {
                ReportingEvent.PageSwipe pageSwipe = (ReportingEvent.PageSwipe)event;
                this.listener.onPageSwipe(pageSwipe.getPagerData(), pageSwipe.getToPageIndex(), pageSwipe.getToPageId(), pageSwipe.getFromPageIndex(), pageSwipe.getFromPageId(), layoutData);
                break;
            }
            case BUTTON_TAP: {
                ReportingEvent.ButtonTap buttonTap = (ReportingEvent.ButtonTap)event;
                this.listener.onButtonTap(buttonTap.getButtonId(), layoutData);
                break;
            }
            case OUTSIDE_DISMISS: {
                ReportingEvent.DismissFromOutside outsideDismiss = (ReportingEvent.DismissFromOutside)event;
                this.listener.onDismiss(outsideDismiss.getDisplayTime());
                break;
            }
            case BUTTON_DISMISS: {
                ReportingEvent.DismissFromButton buttonDismiss = (ReportingEvent.DismissFromButton)event;
                this.listener.onDismiss(buttonDismiss.getButtonId(), buttonDismiss.getButtonDescription(), buttonDismiss.isCancel(), buttonDismiss.getDisplayTime(), layoutData);
                break;
            }
            case FORM_RESULT: {
                ReportingEvent.FormResult formResult = (ReportingEvent.FormResult)event;
                this.listener.onFormResult(formResult.getFormData(), layoutData);
                break;
            }
            case FORM_DISPLAY: {
                ReportingEvent.FormDisplay formDisplay = (ReportingEvent.FormDisplay)event;
                this.listener.onFormDisplay(formDisplay.getFormInfo(), layoutData);
                break;
            }
        }
    }
}

