/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.util;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import androidx.annotation.Dimension;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.urbanairship.android.layout.property.Orientation;
import com.urbanairship.android.layout.property.WindowSize;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonMap;
import com.urbanairship.json.JsonValue;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Scanner;

public final class ResourceUtils {
    private ResourceUtils() {
    }

    @Nullable
    public static JsonMap readJsonAsset(@NonNull Context context, @NonNull String fileName) throws JsonException, IOException {
        JsonValue jsonValue = JsonValue.parseString((String)ResourceUtils.readAsset(context, fileName));
        return jsonValue.getMap();
    }

    @NonNull
    public static List<String> listJsonAssets(@NonNull Context context, @Nullable String path) {
        String[] assets;
        AssetManager assetManager = context.getResources().getAssets();
        try {
            assets = assetManager.list(path == null ? "" : path);
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
        ArrayList<String> jsonAssets = new ArrayList<String>();
        for (String a : assets) {
            if (!a.endsWith(".json")) continue;
            jsonAssets.add(a);
        }
        return jsonAssets;
    }

    @NonNull
    public static String readAsset(@NonNull Context context, @NonNull String fileName) throws IOException {
        return ResourceUtils.readStream(context.getResources().getAssets().open(fileName));
    }

    @Dimension
    public static float dpToPx(@NonNull Context context, @Dimension(unit=0) int dp) {
        Resources r = context.getResources();
        return TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)r.getDisplayMetrics());
    }

    public static boolean isUiModeNight(@NonNull Context context) {
        int mode = context.getResources().getConfiguration().uiMode & 0x30;
        return mode == 32;
    }

    @Nullable
    public static Orientation getOrientation(@NonNull Context context) {
        switch (context.getResources().getConfiguration().orientation) {
            case 1: {
                return Orientation.PORTRAIT;
            }
            case 2: {
                return Orientation.LANDSCAPE;
            }
        }
        return null;
    }

    @Nullable
    public static WindowSize getWindowSize(@NonNull Context context) {
        int screenLayout = context.getResources().getConfiguration().screenLayout;
        switch (screenLayout &= 0xF) {
            case 1: {
                return WindowSize.SMALL;
            }
            case 2: 
            case 3: {
                return WindowSize.MEDIUM;
            }
            case 4: {
                return WindowSize.LARGE;
            }
        }
        return null;
    }

    public static int getDisplayWidthPixels(@NonNull Context context) {
        return context.getResources().getDisplayMetrics().widthPixels;
    }

    public static int getDisplayHeightPixels(@NonNull Context context) {
        return context.getResources().getDisplayMetrics().heightPixels;
    }

    @NonNull
    private static String readStream(@NonNull InputStream inputStream) {
        try (Scanner s = new Scanner(inputStream, "UTF-8").useDelimiter("\\A");){
            String string = s.hasNext() ? s.next() : "";
            return string;
        }
    }
}

