/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.view;

import android.content.Context;
import android.util.AttributeSet;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.SwitchCompat;
import com.urbanairship.android.layout.environment.Environment;
import com.urbanairship.android.layout.model.CheckboxModel;
import com.urbanairship.android.layout.property.CheckboxStyle;
import com.urbanairship.android.layout.property.SwitchStyle;
import com.urbanairship.android.layout.widget.CheckableView;
import com.urbanairship.android.layout.widget.ShapeButton;

public class CheckboxView
extends CheckableView<CheckboxModel> {
    public CheckboxView(@NonNull Context context) {
        super(context);
    }

    public CheckboxView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public CheckboxView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @NonNull
    public static CheckboxView create(@NonNull Context context, @NonNull CheckboxModel model, @NonNull Environment environment) {
        CheckboxView view = new CheckboxView(context);
        view.setModel(model, environment);
        return view;
    }

    @Override
    protected void configure() {
        super.configure();
        ((CheckboxModel)this.getModel()).setListener(this::setCheckedInternal);
    }

    @Override
    @NonNull
    protected SwitchCompat createSwitchView(SwitchStyle style) {
        return new SwitchCompat(this.getContext()){

            public void toggle() {
                ((CheckboxModel)CheckboxView.this.getModel()).onCheckedChange(!this.isChecked());
            }
        };
    }

    @Override
    @NonNull
    protected ShapeButton createCheckboxView(CheckboxStyle style) {
        CheckboxStyle.Binding checked = style.getBindings().getSelected();
        CheckboxStyle.Binding unchecked = style.getBindings().getUnselected();
        return new ShapeButton(this.getContext(), checked.getShapes(), unchecked.getShapes(), checked.getIcon(), unchecked.getIcon()){

            @Override
            public void toggle() {
                ((CheckboxModel)CheckboxView.this.getModel()).onCheckedChange(!this.isChecked());
            }
        };
    }
}

