/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.view;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatImageButton;
import androidx.core.content.ContextCompat;
import com.urbanairship.UAirship;
import com.urbanairship.android.layout.R;
import com.urbanairship.android.layout.environment.Environment;
import com.urbanairship.android.layout.model.ButtonModel;
import com.urbanairship.android.layout.model.ImageButtonModel;
import com.urbanairship.android.layout.property.Image;
import com.urbanairship.android.layout.util.ColorStateListBuilder;
import com.urbanairship.android.layout.util.LayoutUtils;
import com.urbanairship.android.layout.view.BaseView;
import com.urbanairship.images.ImageRequestOptions;
import com.urbanairship.util.UAStringUtil;

public class ImageButtonView
extends AppCompatImageButton
implements BaseView<ImageButtonModel> {
    private ImageButtonModel model;
    private Environment environment;
    private final ButtonModel.Listener modelListener = new ButtonModel.Listener(){

        @Override
        public void setEnabled(boolean isEnabled) {
            ImageButtonView.this.setEnabled(isEnabled);
        }
    };

    public ImageButtonView(@NonNull Context context) {
        super(context);
        this.init(context);
    }

    public ImageButtonView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public ImageButtonView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(@NonNull Context context) {
        Drawable ripple = ContextCompat.getDrawable((Context)context, (int)R.drawable.ua_layout_imagebutton_ripple);
        this.setBackgroundDrawable(ripple);
        this.setClickable(true);
        this.setFocusable(true);
        this.setPadding(0, 0, 0, 0);
    }

    @NonNull
    public static ImageButtonView create(@NonNull Context context, @NonNull ImageButtonModel model, @NonNull Environment environment) {
        ImageButtonView view = new ImageButtonView(context);
        view.setModel(model, environment);
        return view;
    }

    @Override
    public void setModel(@NonNull ImageButtonModel model, @NonNull Environment environment) {
        this.model = model;
        this.environment = environment;
        this.setId(model.getViewId());
        this.configureButton();
    }

    private void configureButton() {
        this.setScaleType(ImageView.ScaleType.FIT_CENTER);
        LayoutUtils.applyBorderAndBackground((View)this, this.model);
        this.model.setViewListener(this.modelListener);
        if (!UAStringUtil.isEmpty((String)this.model.getContentDescription())) {
            this.setContentDescription(this.model.getContentDescription());
        }
        Image image = this.model.getImage();
        switch (image.getType()) {
            case URL: {
                String url = ((Image.Url)image).getUrl();
                String cachedImage = this.environment.imageCache().get(url);
                if (cachedImage != null) {
                    url = cachedImage;
                }
                UAirship.shared().getImageLoader().load(this.getContext(), (ImageView)this, ImageRequestOptions.newBuilder((String)url).build());
                break;
            }
            case ICON: {
                Image.Icon icon = (Image.Icon)image;
                this.setImageDrawable(icon.getDrawable(this.getContext()));
                int normalColor = icon.getTint().resolve(this.getContext());
                int pressedColor = LayoutUtils.generatePressedColor(normalColor);
                int disabledColor = LayoutUtils.generateDisabledColor(normalColor);
                ColorStateList tintList = new ColorStateListBuilder().add(pressedColor, 16842919).add(disabledColor, -16842910).add(normalColor).build();
                this.setImageTintList(tintList);
            }
        }
        this.setOnClickListener(v -> this.model.onClick());
    }
}

