/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.view;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.material.button.MaterialButton;
import com.urbanairship.android.layout.R;
import com.urbanairship.android.layout.environment.Environment;
import com.urbanairship.android.layout.model.ButtonModel;
import com.urbanairship.android.layout.model.LabelButtonModel;
import com.urbanairship.android.layout.util.LayoutUtils;
import com.urbanairship.android.layout.util.ResourceUtils;
import com.urbanairship.android.layout.view.BaseView;
import com.urbanairship.util.UAStringUtil;

public class LabelButtonView
extends MaterialButton
implements BaseView<LabelButtonModel> {
    private LabelButtonModel model;
    private final ButtonModel.Listener modelListener = new ButtonModel.Listener(){

        @Override
        public void setEnabled(boolean isEnabled) {
            LabelButtonView.this.setEnabled(isEnabled);
        }
    };

    public LabelButtonView(@NonNull Context context) {
        super(context, null, R.attr.borderlessButtonStyle);
        this.init();
    }

    public LabelButtonView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public LabelButtonView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.setAllCaps(false);
        this.setSingleLine(true);
        this.setEllipsize(TextUtils.TruncateAt.END);
    }

    @NonNull
    public static LabelButtonView create(@NonNull Context context, @NonNull LabelButtonModel model, @NonNull Environment environment) {
        LabelButtonView view = new LabelButtonView(context);
        view.setModel(model, environment);
        return view;
    }

    @Override
    public void setModel(@NonNull LabelButtonModel model, @NonNull Environment environment) {
        this.model = model;
        this.setId(model.getViewId());
        this.configureButton();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        boolean autoWidth;
        boolean autoHeight = View.MeasureSpec.getMode((int)heightMeasureSpec) != 0x40000000;
        boolean bl = autoWidth = View.MeasureSpec.getMode((int)widthMeasureSpec) != 0x40000000;
        if (autoHeight || autoWidth) {
            int twelveDp = (int)ResourceUtils.dpToPx(this.getContext(), 12);
            int horizontal = autoWidth ? twelveDp : 0;
            int vertical = autoHeight ? twelveDp : 0;
            this.setPadding(horizontal, vertical, horizontal, vertical);
        } else {
            this.setPadding(0, 0, 0, 0);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    private void configureButton() {
        LayoutUtils.applyButtonModel(this, this.model);
        this.model.setViewListener(this.modelListener);
        if (!UAStringUtil.isEmpty((String)this.model.getContentDescription())) {
            this.setContentDescription(this.model.getContentDescription());
        }
        this.setOnClickListener(v -> this.model.onClick());
        this.setMinHeight(0);
        this.setMinimumHeight(0);
        this.setInsetTop(0);
        this.setInsetBottom(0);
    }
}

