/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatTextView;
import com.urbanairship.android.layout.environment.Environment;
import com.urbanairship.android.layout.model.LabelModel;
import com.urbanairship.android.layout.util.LayoutUtils;
import com.urbanairship.android.layout.view.BaseView;
import com.urbanairship.util.UAStringUtil;

public class LabelView
extends AppCompatTextView
implements BaseView<LabelModel> {
    public LabelView(@NonNull Context context) {
        super(context);
        this.init();
    }

    public LabelView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public LabelView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
    }

    @NonNull
    public static LabelView create(@NonNull Context context, @NonNull LabelModel model, @NonNull Environment environment) {
        LabelView view = new LabelView(context);
        view.setModel(model, environment);
        return view;
    }

    @Override
    public void setModel(@NonNull LabelModel model, @NonNull Environment environment) {
        this.setId(model.getViewId());
        LayoutUtils.applyLabelModel((TextView)this, model);
        LayoutUtils.applyBorderAndBackground((View)this, model);
        if (!UAStringUtil.isEmpty((String)model.getContentDescription())) {
            this.setContentDescription(model.getContentDescription());
        }
    }
}

