/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.graphics.Insets;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import com.urbanairship.android.layout.Thomas;
import com.urbanairship.android.layout.environment.Environment;
import com.urbanairship.android.layout.model.LinearLayoutModel;
import com.urbanairship.android.layout.property.Direction;
import com.urbanairship.android.layout.property.Margin;
import com.urbanairship.android.layout.property.Size;
import com.urbanairship.android.layout.util.LayoutUtils;
import com.urbanairship.android.layout.util.ResourceUtils;
import com.urbanairship.android.layout.view.BaseView;
import com.urbanairship.android.layout.widget.WeightlessLinearLayout;
import java.util.List;

public class LinearLayoutView
extends WeightlessLinearLayout
implements BaseView<LinearLayoutModel> {
    private LinearLayoutModel model;
    private Environment environment;

    public LinearLayoutView(@NonNull Context context) {
        super(context);
        this.init();
    }

    public LinearLayoutView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public LinearLayoutView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.setClipChildren(false);
    }

    @NonNull
    public static LinearLayoutView create(@NonNull Context context, @NonNull LinearLayoutModel model, @NonNull Environment environment) {
        LinearLayoutView view = new LinearLayoutView(context);
        view.setModel(model, environment);
        return view;
    }

    @Override
    public void setModel(@NonNull LinearLayoutModel model, @NonNull Environment environment) {
        this.model = model;
        this.environment = environment;
        this.setId(model.getViewId());
        this.configureLinearLayout();
    }

    private void configureLinearLayout() {
        LayoutUtils.applyBorderAndBackground((View)this, this.model);
        this.setOrientation(this.model.getDirection() == Direction.VERTICAL ? 1 : 0);
        this.setGravity(this.model.getDirection() == Direction.VERTICAL ? 1 : 16);
        this.addItems(this.model.getItems());
        ViewCompat.setOnApplyWindowInsetsListener((View)this, (v, insets) -> {
            WindowInsetsCompat noInsets = new WindowInsetsCompat.Builder().setInsets(WindowInsetsCompat.Type.systemBars(), Insets.NONE).build();
            for (int i = 0; i < this.getChildCount(); ++i) {
                ViewCompat.dispatchApplyWindowInsets((View)this.getChildAt(i), (WindowInsetsCompat)noInsets);
            }
            return noInsets;
        });
    }

    private void addItems(List<LinearLayoutModel.Item> items) {
        for (int i = 0; i < items.size(); ++i) {
            LinearLayoutModel.Item item = items.get(i);
            WeightlessLinearLayout.LayoutParams lp = this.generateItemLayoutParams(item);
            View itemView = Thomas.view(this.getContext(), item.getView(), this.environment);
            itemView.setLayoutParams((ViewGroup.LayoutParams)lp);
            this.addViewInLayout(itemView, -1, (ViewGroup.LayoutParams)lp, true);
        }
    }

    private WeightlessLinearLayout.LayoutParams generateItemLayoutParams(@NonNull LinearLayoutModel.Item item) {
        int width = 0;
        int height = 0;
        float maxWidthPercent = 0.0f;
        float maxHeightPercent = 0.0f;
        Size size = item.getSize();
        Size.Dimension w = size.getWidth();
        switch (w.getType()) {
            case AUTO: {
                width = -2;
                maxWidthPercent = 0.0f;
                break;
            }
            case ABSOLUTE: {
                width = (int)ResourceUtils.dpToPx(this.getContext(), w.getInt());
                maxWidthPercent = 0.0f;
                break;
            }
            case PERCENT: {
                width = 0;
                maxWidthPercent = w.getFloat();
            }
        }
        Size.Dimension h = size.getHeight();
        switch (h.getType()) {
            case AUTO: {
                height = -2;
                maxHeightPercent = 0.0f;
                break;
            }
            case ABSOLUTE: {
                height = (int)ResourceUtils.dpToPx(this.getContext(), h.getInt());
                maxHeightPercent = 0.0f;
                break;
            }
            case PERCENT: {
                height = 0;
                maxHeightPercent = h.getFloat();
            }
        }
        WeightlessLinearLayout.LayoutParams lp = new WeightlessLinearLayout.LayoutParams(width, height, maxWidthPercent, maxHeightPercent);
        Margin margin = item.getMargin();
        if (margin != null) {
            lp.topMargin = (int)ResourceUtils.dpToPx(this.getContext(), margin.getTop());
            lp.bottomMargin = (int)ResourceUtils.dpToPx(this.getContext(), margin.getBottom());
            lp.setMarginStart((int)ResourceUtils.dpToPx(this.getContext(), margin.getStart()));
            lp.setMarginEnd((int)ResourceUtils.dpToPx(this.getContext(), margin.getEnd()));
        }
        return lp;
    }
}

