/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.view;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Checkable;
import android.widget.LinearLayout;
import androidx.annotation.NonNull;
import com.urbanairship.android.layout.environment.Environment;
import com.urbanairship.android.layout.model.PagerIndicatorModel;
import com.urbanairship.android.layout.util.LayoutUtils;
import com.urbanairship.android.layout.util.ResourceUtils;
import com.urbanairship.android.layout.view.BaseView;
import com.urbanairship.android.layout.widget.ShapeView;

public class PagerIndicatorView
extends LinearLayout
implements BaseView<PagerIndicatorModel> {
    private PagerIndicatorModel model;
    private final PagerIndicatorModel.Listener listener = new PagerIndicatorModel.Listener(){
        private boolean isInitialized = false;

        @Override
        public void onInit(int size, int position) {
            if (!this.isInitialized) {
                this.isInitialized = true;
                PagerIndicatorView.this.setCount(size);
            }
            PagerIndicatorView.this.setPosition(position);
        }

        @Override
        public void onUpdate(int position) {
            PagerIndicatorView.this.setPosition(position);
        }
    };

    public PagerIndicatorView(@NonNull Context context) {
        super(context);
        this.setId(PagerIndicatorView.generateViewId());
        this.setOrientation(0);
        this.setGravity(17);
    }

    @NonNull
    public static PagerIndicatorView create(@NonNull Context context, @NonNull PagerIndicatorModel model, @NonNull Environment environment) {
        PagerIndicatorView view = new PagerIndicatorView(context);
        view.setModel(model, environment);
        return view;
    }

    @Override
    public void setModel(@NonNull PagerIndicatorModel model, @NonNull Environment environment) {
        this.model = model;
        this.setId(model.getViewId());
        this.configure();
    }

    private void configure() {
        this.model.setListener(this.listener);
        LayoutUtils.applyBorderAndBackground((View)this, this.model);
        this.model.onConfigured();
    }

    public void setCount(int count) {
        Context context = this.getContext();
        PagerIndicatorModel.Bindings bindings = this.model.getBindings();
        PagerIndicatorModel.Binding checked = bindings.getSelected();
        PagerIndicatorModel.Binding unchecked = bindings.getUnselected();
        int spacing = (int)ResourceUtils.dpToPx(context, this.model.getIndicatorSpacing());
        int halfSpacing = (int)((float)spacing / 2.0f);
        for (int i = 0; i < count; ++i) {
            ShapeView view = new ShapeView(this.getContext(), checked.getShapes(), unchecked.getShapes(), checked.getIcon(), unchecked.getIcon());
            view.setId(this.model.getIndicatorViewId(i));
            view.setAdjustViewBounds(true);
            LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-2, -1);
            lp.setMarginStart(i == 0 ? spacing : halfSpacing);
            lp.setMarginEnd(i == count - 1 ? spacing : halfSpacing);
            this.addView((View)view, (ViewGroup.LayoutParams)lp);
        }
    }

    public void setPosition(int position) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            ((Checkable)this.getChildAt(i)).setChecked(i == position);
        }
    }
}

