/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import com.urbanairship.android.layout.environment.Environment;
import com.urbanairship.android.layout.model.PagerModel;
import com.urbanairship.android.layout.util.LayoutUtils;
import com.urbanairship.android.layout.view.BaseView;
import com.urbanairship.android.layout.widget.PagerRecyclerView;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class PagerView
extends FrameLayout
implements BaseView<PagerModel> {
    private PagerModel model;
    private Environment environment;
    private PagerRecyclerView view = null;
    private final PagerModel.Listener modelListener = new PagerModel.Listener(){

        @Override
        public void onScrollToNext() {
            int position = PagerView.this.view.getDisplayedItemPosition();
            int nextPosition = position + 1;
            if (position != -1 && nextPosition < PagerView.this.view.getAdapterItemCount()) {
                PagerView.this.view.scrollTo(nextPosition);
            }
        }

        @Override
        public void onScrollToPrevious() {
            int position = PagerView.this.view.getDisplayedItemPosition();
            int previousPosition = position - 1;
            if (position != -1 && previousPosition > -1) {
                PagerView.this.view.scrollTo(previousPosition);
            }
        }
    };

    public PagerView(@NonNull Context context) {
        super(context);
        this.init();
    }

    public PagerView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public PagerView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
    }

    @NonNull
    public static PagerView create(@NonNull Context context, @NonNull PagerModel model, @NonNull Environment environment) {
        PagerView view = new PagerView(context);
        view.setModel(model, environment);
        return view;
    }

    @Override
    public void setModel(@NonNull PagerModel model, @NonNull Environment environment) {
        this.model = model;
        this.environment = environment;
        this.setId(model.getViewId());
        this.configure();
    }

    private void configure() {
        this.view = new PagerRecyclerView(this.getContext());
        this.view.configure(this.model, this.environment);
        this.addView((View)this.view, -1, -1);
        LayoutUtils.applyBorderAndBackground((View)this, this.model);
        this.model.setListener(this.modelListener);
        this.model.onConfigured(this.view.getDisplayedItemPosition(), this.environment.displayTimer().getTime());
        ViewCompat.setOnApplyWindowInsetsListener((View)this, (v, insets) -> ViewCompat.dispatchApplyWindowInsets((View)this.view, (WindowInsetsCompat)insets));
    }
}

