/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.view;

import android.content.Context;
import android.text.Editable;
import android.text.TextWatcher;
import android.text.method.MovementMethod;
import android.text.method.ScrollingMovementMethod;
import android.util.AttributeSet;
import android.view.View;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.appcompat.widget.AppCompatEditText;
import com.urbanairship.android.layout.environment.Environment;
import com.urbanairship.android.layout.model.TextInputModel;
import com.urbanairship.android.layout.util.LayoutUtils;
import com.urbanairship.android.layout.view.BaseView;
import com.urbanairship.util.UAStringUtil;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class TextInputView
extends AppCompatEditText
implements BaseView<TextInputModel> {
    private TextInputModel model;
    private final TextWatcher textWatcher = new TextWatcher(){

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
            TextInputView.this.model.onInputChange(s.toString());
        }

        public void afterTextChanged(Editable s) {
        }
    };
    private final View.OnTouchListener touchListener = (v, event) -> {
        v.getParent().requestDisallowInterceptTouchEvent(true);
        if ((event.getAction() & 0xFF) == 1) {
            v.getParent().requestDisallowInterceptTouchEvent(false);
        }
        return false;
    };

    public TextInputView(@NonNull Context context) {
        super(context);
        this.init();
    }

    public TextInputView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public TextInputView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.setBackground(null);
    }

    @Nullable
    public InputConnection onCreateInputConnection(@NonNull EditorInfo outAttrs) {
        outAttrs.imeOptions |= 0x12000000;
        return super.onCreateInputConnection(outAttrs);
    }

    @NonNull
    public static TextInputView create(@NonNull Context context, @NonNull TextInputModel model, Environment environment) {
        TextInputView view = new TextInputView(context);
        view.setModel(model, environment);
        return view;
    }

    @Override
    public void setModel(@NonNull TextInputModel model, @NonNull Environment environment) {
        this.model = model;
        this.setId(model.getViewId());
        this.configure();
    }

    private void configure() {
        LayoutUtils.applyTextInputModel(this, this.model);
        if (!UAStringUtil.isEmpty((String)this.model.getContentDescription())) {
            this.setContentDescription(this.model.getContentDescription());
        }
        if (this.model.getValue() != null) {
            this.setText(this.model.getValue());
        }
        this.addTextChangedListener(this.textWatcher);
        this.setOnTouchListener(this.touchListener);
        this.setMovementMethod((MovementMethod)new ScrollingMovementMethod());
        this.model.onConfigured();
        LayoutUtils.doOnAttachToWindow((View)this, this.model::onAttachedToWindow);
    }
}

