/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.widget;

import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.urbanairship.android.layout.property.ConstrainedSize;
import com.urbanairship.android.layout.util.ResourceUtils;
import java.lang.ref.WeakReference;

public class ConstrainedViewDelegate {
    private final WeakReference<View> weakView;
    private final ConstrainedSize size;

    ConstrainedViewDelegate(@NonNull View view, @NonNull ConstrainedSize size) {
        this.weakView = new WeakReference<View>(view);
        this.size = size;
    }

    public void onMeasure(int widthMeasureSpec, int heightMeasureSpec, @NonNull ChildMeasurer childMeasurer, @NonNull Measurable superMeasurer) {
        boolean wrapContentHeight;
        View view = (View)this.weakView.get();
        if (view == null) {
            return;
        }
        int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int maxWidth = 0;
        int maxHeight = 0;
        boolean wrapContentWidth = view.getLayoutParams().width == -2;
        boolean bl = wrapContentHeight = view.getLayoutParams().height == -2;
        if (!wrapContentWidth) {
            maxWidth = widthSize;
        }
        if (!wrapContentHeight) {
            maxHeight = heightSize;
        }
        if (wrapContentWidth || wrapContentHeight) {
            if (view instanceof ViewGroup) {
                ViewGroup viewGroup = (ViewGroup)view;
                for (int i = 0; i < viewGroup.getChildCount(); ++i) {
                    View child = viewGroup.getChildAt(i);
                    childMeasurer.measureChild(child, widthMeasureSpec, heightMeasureSpec);
                    ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
                    if (wrapContentWidth) {
                        maxWidth = Math.max(maxWidth, child.getMeasuredWidth() + lp.leftMargin + lp.rightMargin);
                    }
                    if (!wrapContentHeight) continue;
                    maxHeight = Math.max(maxHeight, child.getMeasuredHeight() + lp.topMargin + lp.bottomMargin);
                }
            }
            int constrainedWidth = this.constrainDimension(this.size.getMinWidth(), this.size.getMaxWidth(), widthSize, maxWidth);
            int constrainedHeight = this.constrainDimension(this.size.getMinHeight(), this.size.getMaxHeight(), heightSize, maxHeight);
            widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)constrainedWidth, (int)0x40000000);
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)constrainedHeight, (int)0x40000000);
        }
        superMeasurer.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    private int constrainDimension(@Nullable ConstrainedSize.ConstrainedDimension min, @Nullable ConstrainedSize.ConstrainedDimension max, int specSize, int measuredMaxSize) {
        View view = (View)this.weakView.get();
        if (view == null) {
            return measuredMaxSize;
        }
        int constrainedDimension = measuredMaxSize;
        if (min != null) {
            int minSize = Integer.MIN_VALUE;
            switch (min.getType()) {
                case PERCENT: {
                    minSize = (int)((float)specSize * min.getFloat());
                    break;
                }
                case ABSOLUTE: {
                    minSize = (int)ResourceUtils.dpToPx(view.getContext(), min.getInt());
                }
            }
            if (constrainedDimension < minSize) {
                constrainedDimension = minSize;
            }
        }
        if (max != null) {
            int maxSize = Integer.MAX_VALUE;
            switch (max.getType()) {
                case PERCENT: {
                    maxSize = (int)((float)specSize * max.getFloat());
                    break;
                }
                case ABSOLUTE: {
                    maxSize = (int)ResourceUtils.dpToPx(view.getContext(), max.getInt());
                }
            }
            if (constrainedDimension > maxSize) {
                constrainedDimension = maxSize;
            }
        }
        return constrainedDimension;
    }

    @FunctionalInterface
    static interface Measurable {
        public void onMeasure(int var1, int var2);
    }

    @FunctionalInterface
    static interface ChildMeasurer {
        public void measureChild(@NonNull View var1, int var2, int var3);
    }
}

