/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.widget;

import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.drawable.Drawable;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.graphics.drawable.DrawableCompat;

public class DrawableWrapper
extends Drawable
implements Drawable.Callback {
    private final DrawableWrapperState state;
    private Drawable drawable;

    DrawableWrapper(@Nullable DrawableWrapperState state, @Nullable Resources res) {
        this.state = state;
        if (state != null && state.drawableState != null) {
            this.setDrawable(state.drawableState.newDrawable(res));
        }
    }

    public DrawableWrapper(@Nullable Drawable drawable2) {
        this.state = null;
        this.setDrawable(drawable2);
    }

    public void draw(@NonNull Canvas canvas) {
        this.drawable.draw(canvas);
    }

    protected void onBoundsChange(@NonNull Rect bounds) {
        this.drawable.setBounds(bounds);
    }

    public void setChangingConfigurations(int configs) {
        this.drawable.setChangingConfigurations(configs);
    }

    public int getChangingConfigurations() {
        return this.drawable.getChangingConfigurations();
    }

    public void setDither(boolean dither) {
        if (this.drawable != null) {
            this.drawable.setDither(dither);
        }
    }

    public void setFilterBitmap(boolean filter) {
        this.drawable.setFilterBitmap(filter);
    }

    public void setAlpha(int alpha) {
        this.drawable.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter cf) {
        this.drawable.setColorFilter(cf);
    }

    public boolean isStateful() {
        return this.drawable.isStateful();
    }

    public boolean setState(int[] stateSet) {
        return this.drawable.setState(stateSet);
    }

    public int[] getState() {
        return this.drawable.getState();
    }

    public void jumpToCurrentState() {
        this.drawable.jumpToCurrentState();
    }

    public Drawable getCurrent() {
        return this.drawable.getCurrent();
    }

    public boolean setVisible(boolean visible, boolean restart) {
        return super.setVisible(visible, restart) || this.drawable.setVisible(visible, restart);
    }

    public int getOpacity() {
        return this.drawable.getOpacity();
    }

    public Region getTransparentRegion() {
        return this.drawable.getTransparentRegion();
    }

    public int getIntrinsicWidth() {
        return this.drawable.getIntrinsicWidth();
    }

    public int getIntrinsicHeight() {
        return this.drawable.getIntrinsicHeight();
    }

    public int getMinimumWidth() {
        return this.drawable.getMinimumWidth();
    }

    public int getMinimumHeight() {
        return this.drawable.getMinimumHeight();
    }

    public boolean getPadding(Rect padding) {
        return this.drawable.getPadding(padding);
    }

    public void invalidateDrawable(Drawable who) {
        this.invalidateSelf();
    }

    public void scheduleDrawable(Drawable who, Runnable what, long when) {
        this.scheduleSelf(what, when);
    }

    public void unscheduleDrawable(Drawable who, Runnable what) {
        this.unscheduleSelf(what);
    }

    protected boolean onLevelChange(int level) {
        return this.drawable.setLevel(level);
    }

    public void setAutoMirrored(boolean mirrored) {
        DrawableCompat.setAutoMirrored((Drawable)this.drawable, (boolean)mirrored);
    }

    public boolean isAutoMirrored() {
        return DrawableCompat.isAutoMirrored((Drawable)this.drawable);
    }

    public void setTint(int tint) {
        DrawableCompat.setTint((Drawable)this.drawable, (int)tint);
    }

    public void setTintList(ColorStateList tint) {
        DrawableCompat.setTintList((Drawable)this.drawable, (ColorStateList)tint);
    }

    public void setTintMode(PorterDuff.Mode tintMode) {
        DrawableCompat.setTintMode((Drawable)this.drawable, (PorterDuff.Mode)tintMode);
    }

    public void setHotspot(float x, float y) {
        DrawableCompat.setHotspot((Drawable)this.drawable, (float)x, (float)y);
    }

    public void setHotspotBounds(int left, int top, int right, int bottom) {
        DrawableCompat.setHotspotBounds((Drawable)this.drawable, (int)left, (int)top, (int)right, (int)bottom);
    }

    public Drawable getDrawable() {
        return this.drawable;
    }

    public void setDrawable(@Nullable Drawable drawable2) {
        if (this.drawable != null) {
            this.drawable.setCallback(null);
        }
        this.drawable = drawable2;
        if (drawable2 != null) {
            drawable2.setCallback((Drawable.Callback)this);
            drawable2.setVisible(this.isVisible(), true);
            drawable2.setState(this.getState());
            drawable2.setLevel(this.getLevel());
            drawable2.setBounds(this.getBounds());
            if (Build.VERSION.SDK_INT >= 23) {
                drawable2.setLayoutDirection(this.getLayoutDirection());
            }
            if (this.state != null) {
                this.state.drawableState = drawable2.getConstantState();
            }
        }
        this.invalidateSelf();
    }

    static abstract class DrawableWrapperState
    extends Drawable.ConstantState {
        int changingConfigurations;
        Drawable.ConstantState drawableState;

        DrawableWrapperState(@Nullable DrawableWrapperState orig, @Nullable Resources res) {
            if (orig != null) {
                this.changingConfigurations = orig.changingConfigurations;
                this.drawableState = orig.drawableState;
            }
        }

        @NonNull
        public Drawable newDrawable() {
            return this.newDrawable(null);
        }

        @NonNull
        public abstract Drawable newDrawable(@Nullable Resources var1);

        public int getChangingConfigurations() {
            return this.changingConfigurations | (this.drawableState != null ? this.drawableState.getChangingConfigurations() : 0);
        }
    }
}

