/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.model;

import android.content.Context;
import android.view.View;
import com.urbanairship.android.layout.environment.LayoutState;
import com.urbanairship.android.layout.environment.ModelEnvironment;
import com.urbanairship.android.layout.environment.SharedState;
import com.urbanairship.android.layout.environment.State;
import com.urbanairship.android.layout.environment.ViewEnvironment;
import com.urbanairship.android.layout.event.ReportingEvent;
import com.urbanairship.android.layout.info.PagerInfo;
import com.urbanairship.android.layout.info.VisibilityInfo;
import com.urbanairship.android.layout.model.BaseModel;
import com.urbanairship.android.layout.model.ModelProperties;
import com.urbanairship.android.layout.property.Border;
import com.urbanairship.android.layout.property.Color;
import com.urbanairship.android.layout.property.EnableBehaviorType;
import com.urbanairship.android.layout.property.EventHandler;
import com.urbanairship.android.layout.property.ViewType;
import com.urbanairship.android.layout.reporting.PagerData;
import com.urbanairship.android.layout.util.PagerScrollEvent;
import com.urbanairship.android.layout.util.ViewExtensionsKt;
import com.urbanairship.android.layout.view.PagerView;
import com.urbanairship.json.JsonValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u000278B;\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010B\u0083\u0001\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u0012\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u0012\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u0012\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u0012\u0010\b\u0002\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u0007\u0012\u0010\b\u0002\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\u001d\u001a\u00020\r\u0012\u0006\u0010\u001e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u001fJ\u000e\u0010+\u001a\u00020%2\u0006\u0010,\u001a\u00020%J\u0018\u0010-\u001a\u00020\u00022\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201H\u0014J\u0015\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u0002H\u0010\u00a2\u0006\u0002\b5J\u0010\u00106\u001a\u0002032\u0006\u0010\t\u001a\u00020\u000bH\u0002R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010 R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001a\u0010#\u001a\u000e\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020%0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010&\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\"R\u0011\u0010(\u001a\u00020%\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*\u00a8\u00069"}, d2={"Lcom/urbanairship/android/layout/model/PagerModel;", "Lcom/urbanairship/android/layout/model/BaseModel;", "Lcom/urbanairship/android/layout/view/PagerView;", "Lcom/urbanairship/android/layout/model/PagerModel$Listener;", "info", "Lcom/urbanairship/android/layout/info/PagerInfo;", "items", "", "Lcom/urbanairship/android/layout/model/PagerModel$Item;", "pagerState", "Lcom/urbanairship/android/layout/environment/SharedState;", "Lcom/urbanairship/android/layout/environment/State$Pager;", "env", "Lcom/urbanairship/android/layout/environment/ModelEnvironment;", "props", "Lcom/urbanairship/android/layout/model/ModelProperties;", "(Lcom/urbanairship/android/layout/info/PagerInfo;Ljava/util/List;Lcom/urbanairship/android/layout/environment/SharedState;Lcom/urbanairship/android/layout/environment/ModelEnvironment;Lcom/urbanairship/android/layout/model/ModelProperties;)V", "isSwipeDisabled", "", "backgroundColor", "Lcom/urbanairship/android/layout/property/Color;", "border", "Lcom/urbanairship/android/layout/property/Border;", "visibility", "Lcom/urbanairship/android/layout/info/VisibilityInfo;", "eventHandlers", "Lcom/urbanairship/android/layout/property/EventHandler;", "enableBehaviors", "Lcom/urbanairship/android/layout/property/EnableBehaviorType;", "environment", "properties", "(Ljava/util/List;ZLcom/urbanairship/android/layout/property/Color;Lcom/urbanairship/android/layout/property/Border;Lcom/urbanairship/android/layout/info/VisibilityInfo;Ljava/util/List;Ljava/util/List;Lcom/urbanairship/android/layout/environment/SharedState;Lcom/urbanairship/android/layout/environment/ModelEnvironment;Lcom/urbanairship/android/layout/model/ModelProperties;)V", "()Z", "getItems", "()Ljava/util/List;", "pageViewIds", "", "", "pages", "getPages", "recyclerViewId", "getRecyclerViewId", "()I", "getPageViewId", "position", "onCreateView", "context", "Landroid/content/Context;", "viewEnvironment", "Lcom/urbanairship/android/layout/environment/ViewEnvironment;", "onViewAttached", "", "view", "onViewAttached$urbanairship_layout_release", "reportPageSwipe", "Item", "Listener", "urbanairship-layout_release"})
public final class PagerModel
extends BaseModel<PagerView, Listener> {
    @NotNull
    private final List<Item> items;
    private final boolean isSwipeDisabled;
    @NotNull
    private final SharedState<State.Pager> pagerState;
    private final int recyclerViewId;
    @NotNull
    private final List<BaseModel<?, ?>> pages;
    @NotNull
    private final Map<Integer, Integer> pageViewIds;

    /*
     * WARNING - void declaration
     */
    public PagerModel(@NotNull List<Item> items, boolean isSwipeDisabled, @Nullable Color backgroundColor, @Nullable Border border, @Nullable VisibilityInfo visibility, @Nullable List<EventHandler> eventHandlers, @Nullable List<? extends EnableBehaviorType> enableBehaviors, @NotNull SharedState<State.Pager> pagerState, @NotNull ModelEnvironment environment, @NotNull ModelProperties properties) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Intrinsics.checkNotNullParameter(pagerState, (String)"pagerState");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        super(ViewType.PAGER, backgroundColor, border, visibility, eventHandlers, enableBehaviors, environment, properties);
        this.items = items;
        this.isSwipeDisabled = isSwipeDisabled;
        this.pagerState = pagerState;
        this.recyclerViewId = View.generateViewId();
        Iterable iterable = this.items;
        PagerModel pagerModel = this;
        boolean $i$f$map = false;
        void var13_14 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Item item = (Item)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getView());
        }
        pagerModel.pages = (List)destination$iv$iv;
        this.pageViewIds = new LinkedHashMap();
        this.pagerState.update((Function1<State.Pager, State.Pager>)((Function1)new Function1<State.Pager, State.Pager>(){

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final State.Pager invoke(@NotNull State.Pager state) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                Iterable iterable = this.getItems();
                State.Pager pager = state;
                boolean $i$f$map = false;
                void var4_5 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Item item = (Item)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getIdentifier());
                }
                return pager.copyWithPageIds((List)destination$iv$iv);
            }
        }));
    }

    public /* synthetic */ PagerModel(List list, boolean bl, Color color, Border border, VisibilityInfo visibilityInfo, List list2, List list3, SharedState sharedState, ModelEnvironment modelEnvironment, ModelProperties modelProperties, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            color = null;
        }
        if ((n & 8) != 0) {
            border = null;
        }
        if ((n & 0x10) != 0) {
            visibilityInfo = null;
        }
        if ((n & 0x20) != 0) {
            list2 = null;
        }
        if ((n & 0x40) != 0) {
            list3 = null;
        }
        this(list, bl, color, border, visibilityInfo, (List<EventHandler>)list2, list3, sharedState, modelEnvironment, modelProperties);
    }

    @NotNull
    public final List<Item> getItems() {
        return this.items;
    }

    public final boolean isSwipeDisabled() {
        return this.isSwipeDisabled;
    }

    public PagerModel(@NotNull PagerInfo info, @NotNull List<Item> items, @NotNull SharedState<State.Pager> pagerState, @NotNull ModelEnvironment env, @NotNull ModelProperties props) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Intrinsics.checkNotNullParameter(pagerState, (String)"pagerState");
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)props, (String)"props");
        this(items, info.isSwipeDisabled(), info.getBackgroundColor(), info.getBorder(), info.getVisibility(), info.getEventHandlers(), info.getEnableBehaviors(), pagerState, env, props);
    }

    public final int getRecyclerViewId() {
        return this.recyclerViewId;
    }

    @NotNull
    public final List<BaseModel<?, ?>> getPages() {
        return this.pages;
    }

    @Override
    @NotNull
    protected PagerView onCreateView(@NotNull Context context, @NotNull ViewEnvironment viewEnvironment) {
        PagerView pagerView;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)viewEnvironment, (String)"viewEnvironment");
        PagerView $this$onCreateView_u24lambda_u2d1 = pagerView = new PagerView(context, this, viewEnvironment);
        boolean bl = false;
        $this$onCreateView_u24lambda_u2d1.setId(this.getViewId());
        return pagerView;
    }

    @Override
    public void onViewAttached$urbanairship_layout_release(@NotNull PagerView view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        BuildersKt.launch$default((CoroutineScope)this.getViewScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ PagerModel this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = PagerModel.access$getPagerState$p(this.this$0).getChanges().collect(new FlowCollector(this.this$0){
                            final /* synthetic */ PagerModel this$0;
                            {
                                this.this$0 = $receiver;
                            }

                            @Nullable
                            public final Object emit(@NotNull State.Pager it, @NotNull Continuation<? super Unit> $completion) {
                                block0: {
                                    Listener listener2 = (Listener)this.this$0.getListener$urbanairship_layout_release();
                                    if (listener2 == null) break block0;
                                    listener2.scrollTo(it.getPageIndex());
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) throw new KotlinNothingValueException();
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        BuildersKt.launch$default((CoroutineScope)this.getViewScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(view, this, null){
            int label;
            final /* synthetic */ PagerView $view;
            final /* synthetic */ PagerModel this$0;
            {
                this.$view = $view;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = ViewExtensionsKt.pagerScrolls(this.$view).collect(new FlowCollector(this.this$0){
                            final /* synthetic */ PagerModel this$0;
                            {
                                this.this$0 = $receiver;
                            }

                            @Nullable
                            public final Object emit(@NotNull PagerScrollEvent pagerScrollEvent, @NotNull Continuation<? super Unit> $completion) {
                                block1: {
                                    int position = pagerScrollEvent.component1();
                                    boolean isInternalScroll = pagerScrollEvent.component2();
                                    PagerModel.access$getPagerState$p(this.this$0).update((Function1)new Function1<State.Pager, State.Pager>(position){
                                        final /* synthetic */ int $position;
                                        {
                                            this.$position = $position;
                                            super(1);
                                        }

                                        @NotNull
                                        public final State.Pager invoke(@NotNull State.Pager state) {
                                            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                                            return state.copyWithPageIndex(this.$position);
                                        }
                                    });
                                    if (!isInternalScroll) {
                                        PagerModel.access$reportPageSwipe(this.this$0, (State.Pager)PagerModel.access$getPagerState$p(this.this$0).getChanges().getValue());
                                    }
                                    Map<String, JsonValue> map2 = this.this$0.getItems().get(position).getActions();
                                    if (map2 == null) break block1;
                                    Map<String, JsonValue> map3 = map2;
                                    PagerModel pagerModel = this.this$0;
                                    Map<String, JsonValue> actions = map3;
                                    boolean bl = false;
                                    BaseModel.runActions$default(pagerModel, actions, null, 2, null);
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * WARNING - void declaration
     */
    public final int getPageViewId(int position) {
        Object object;
        void $this$getOrPut$iv;
        Map<Integer, Integer> map2 = this.pageViewIds;
        Integer key$iv = position;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Integer answer$iv = View.generateViewId();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return ((Number)object).intValue();
    }

    private final void reportPageSwipe(State.Pager pagerState) {
        PagerData pagerContext = pagerState.reportingContext();
        this.report(new ReportingEvent.PageSwipe(pagerContext, pagerState.getLastPageIndex(), this.items.get(pagerState.getLastPageIndex()).getIdentifier(), pagerState.getPageIndex(), this.items.get(pagerState.getPageIndex()).getIdentifier()), LayoutState.reportingContext$default(this.getLayoutState(), null, pagerContext, null, 5, null));
    }

    public static final /* synthetic */ SharedState access$getPagerState$p(PagerModel $this) {
        return $this.pagerState;
    }

    public static final /* synthetic */ void access$reportPageSwipe(PagerModel $this, State.Pager pagerState) {
        $this.reportPageSwipe(pagerState);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B7\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003j\u0002`\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u00a2\u0006\u0002\u0010\nR\u001f\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u0002\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/urbanairship/android/layout/model/PagerModel$Item;", "", "view", "Lcom/urbanairship/android/layout/model/BaseModel;", "Lcom/urbanairship/android/layout/model/AnyModel;", "identifier", "", "actions", "", "Lcom/urbanairship/json/JsonValue;", "(Lcom/urbanairship/android/layout/model/BaseModel;Ljava/lang/String;Ljava/util/Map;)V", "getActions", "()Ljava/util/Map;", "getIdentifier", "()Ljava/lang/String;", "getView", "()Lcom/urbanairship/android/layout/model/BaseModel;", "urbanairship-layout_release"})
    public static final class Item {
        @NotNull
        private final BaseModel<?, ?> view;
        @NotNull
        private final String identifier;
        @Nullable
        private final Map<String, JsonValue> actions;

        public Item(@NotNull BaseModel<?, ?> view, @NotNull String identifier, @Nullable Map<String, ? extends JsonValue> actions) {
            Intrinsics.checkNotNullParameter(view, (String)"view");
            Intrinsics.checkNotNullParameter((Object)identifier, (String)"identifier");
            this.view = view;
            this.identifier = identifier;
            this.actions = actions;
        }

        @NotNull
        public final BaseModel<?, ?> getView() {
            return this.view;
        }

        @NotNull
        public final String getIdentifier() {
            return this.identifier;
        }

        @Nullable
        public final Map<String, JsonValue> getActions() {
            return this.actions;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/urbanairship/android/layout/model/PagerModel$Listener;", "Lcom/urbanairship/android/layout/model/BaseModel$Listener;", "scrollTo", "", "position", "", "urbanairship-layout_release"})
    public static interface Listener
    extends BaseModel.Listener {
        public void scrollTo(int var1);
    }
}

