/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.property;

import androidx.annotation.NonNull;
import com.urbanairship.json.JsonException;
import java.util.Locale;

public enum Orientation {
    PORTRAIT("portrait"),
    LANDSCAPE("landscape");

    @NonNull
    private final String value;

    private Orientation(String value) {
        this.value = value;
    }

    @NonNull
    public static Orientation from(@NonNull String value) throws JsonException {
        for (Orientation o : Orientation.values()) {
            if (!o.value.equals(value.toLowerCase(Locale.ROOT))) continue;
            return o;
        }
        throw new JsonException("Unknown Orientation value: " + value);
    }

    @NonNull
    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }
}

