/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.property;

import androidx.annotation.NonNull;
import com.urbanairship.json.JsonException;
import java.util.Locale;

public enum Platform {
    ANDROID("android"),
    IOS("ios"),
    WEB("web");

    @NonNull
    private final String value;

    private Platform(String value) {
        this.value = value;
    }

    @NonNull
    public static Platform from(@NonNull String value) throws JsonException {
        for (Platform type : Platform.values()) {
            if (!type.value.equals(value.toLowerCase(Locale.ROOT))) continue;
            return type;
        }
        throw new JsonException("Unknown Platform value: " + value);
    }

    @NonNull
    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }
}

