/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.view;

import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import com.google.android.material.button.MaterialButton;
import com.urbanairship.android.layout.R;
import com.urbanairship.android.layout.model.ButtonModel;
import com.urbanairship.android.layout.model.LabelButtonModel;
import com.urbanairship.android.layout.util.LayoutUtils;
import com.urbanairship.android.layout.util.ResourceUtils;
import com.urbanairship.android.layout.util.StringExtensionsKt;
import com.urbanairship.android.layout.util.ViewExtensionsKt;
import com.urbanairship.android.layout.view.BaseView;
import com.urbanairship.android.layout.widget.TappableView;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0014J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/urbanairship/android/layout/view/LabelButtonView;", "Lcom/google/android/material/button/MaterialButton;", "Lcom/urbanairship/android/layout/view/BaseView;", "Lcom/urbanairship/android/layout/widget/TappableView;", "context", "Landroid/content/Context;", "model", "Lcom/urbanairship/android/layout/model/LabelButtonModel;", "(Landroid/content/Context;Lcom/urbanairship/android/layout/model/LabelButtonModel;)V", "onMeasure", "", "widthMeasureSpec", "", "heightMeasureSpec", "taps", "Lkotlinx/coroutines/flow/Flow;", "urbanairship-layout_release"})
public final class LabelButtonView
extends MaterialButton
implements BaseView,
TappableView {
    public LabelButtonView(@NotNull Context context, @NotNull LabelButtonModel model) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        super(context, null, R.attr.borderlessButtonStyle);
        this.setAllCaps(false);
        this.setSingleLine(true);
        this.setEllipsize(TextUtils.TruncateAt.END);
        this.setMinHeight(0);
        this.setMinimumHeight(0);
        this.setInsetTop(0);
        this.setInsetBottom(0);
        LayoutUtils.applyButtonModel(this, model);
        StringExtensionsKt.ifNotEmpty(model.getContentDescription(), (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(){

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.setContentDescription(it);
            }
        }));
        model.setListener$urbanairship_layout_release(new ButtonModel.Listener(){

            @Override
            public void setEnabled(boolean enabled) {
                this.setEnabled(enabled);
            }

            @Override
            public void setVisibility(boolean visible) {
                View $this$isGone$iv = (View)this;
                boolean $i$f$setGone = false;
                $this$isGone$iv.setVisibility(visible ? 8 : 0);
            }

            @Override
            public void dismissSoftKeyboard() {
                LayoutUtils.dismissSoftKeyboard((View)this);
            }
        });
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        boolean autoWidth;
        boolean autoHeight = View.MeasureSpec.getMode((int)heightMeasureSpec) != 0x40000000;
        boolean bl = autoWidth = View.MeasureSpec.getMode((int)widthMeasureSpec) != 0x40000000;
        if (autoHeight || autoWidth) {
            int twelveDp = (int)ResourceUtils.dpToPx(this.getContext(), 12);
            int horizontal = autoWidth ? twelveDp : 0;
            int vertical = autoHeight ? twelveDp : 0;
            this.setPadding(horizontal, vertical, horizontal, vertical);
        } else {
            this.setPadding(0, 0, 0, 0);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    @Override
    @NotNull
    public Flow<Unit> taps() {
        return ViewExtensionsKt.debouncedClicks$default((View)this, 0L, 1, null);
    }
}

