/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.view;

import android.content.Context;
import android.util.SparseIntArray;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Checkable;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.urbanairship.android.layout.model.BaseModel;
import com.urbanairship.android.layout.model.ScoreModel;
import com.urbanairship.android.layout.property.ScoreStyle;
import com.urbanairship.android.layout.property.ScoreType;
import com.urbanairship.android.layout.property.TextAppearance;
import com.urbanairship.android.layout.shape.Shape;
import com.urbanairship.android.layout.util.ConstraintSetBuilder;
import com.urbanairship.android.layout.util.LayoutUtils;
import com.urbanairship.android.layout.util.StringExtensionsKt;
import com.urbanairship.android.layout.view.BaseView;
import com.urbanairship.android.layout.widget.ShapeButton;
import com.urbanairship.android.layout.widget.TappableView;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0001(B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0017H\u0002J\u0015\u0010\"\u001a\u00020\u000b2\b\u0010!\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\u0002\u0010#J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000b0%H\u0016J\u0010\u0010&\u001a\u00020\u000b2\u0006\u0010'\u001a\u00020\rH\u0002R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0018\u00a8\u0006)"}, d2={"Lcom/urbanairship/android/layout/view/ScoreView;", "Landroidx/constraintlayout/widget/ConstraintLayout;", "Lcom/urbanairship/android/layout/view/BaseView;", "Lcom/urbanairship/android/layout/widget/TappableView;", "context", "Landroid/content/Context;", "model", "Lcom/urbanairship/android/layout/model/ScoreModel;", "(Landroid/content/Context;Lcom/urbanairship/android/layout/model/ScoreModel;)V", "clicksChannel", "Lkotlinx/coroutines/channels/Channel;", "", "isEnabled", "", "scoreSelectedListener", "Lcom/urbanairship/android/layout/view/ScoreView$OnScoreSelectedListener;", "getScoreSelectedListener", "()Lcom/urbanairship/android/layout/view/ScoreView$OnScoreSelectedListener;", "setScoreSelectedListener", "(Lcom/urbanairship/android/layout/view/ScoreView$OnScoreSelectedListener;)V", "scoreToViewIds", "Landroid/util/SparseIntArray;", "selectedScore", "", "Ljava/lang/Integer;", "configureNumberRange", "style", "Lcom/urbanairship/android/layout/property/ScoreStyle$NumberRange;", "constraints", "Lcom/urbanairship/android/layout/util/ConstraintSetBuilder;", "onScoreClick", "view", "Landroid/view/View;", "score", "setSelectedScore", "(Ljava/lang/Integer;)V", "taps", "Lkotlinx/coroutines/flow/Flow;", "updateEnabledState", "enabled", "OnScoreSelectedListener", "urbanairship-layout_release"})
public final class ScoreView
extends ConstraintLayout
implements BaseView,
TappableView {
    @NotNull
    private final Channel<Unit> clicksChannel;
    @Nullable
    private OnScoreSelectedListener scoreSelectedListener;
    @NotNull
    private final SparseIntArray scoreToViewIds;
    @Nullable
    private Integer selectedScore;
    private boolean isEnabled;

    public ScoreView(@NotNull Context context, @NotNull ScoreModel model) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        super(context);
        this.clicksChannel = ChannelKt.Channel$default((int)Integer.MAX_VALUE, null, null, (int)6, null);
        this.scoreToViewIds = new SparseIntArray();
        this.isEnabled = true;
        LayoutUtils.applyBorderAndBackground((View)this, model);
        ConstraintSetBuilder constraintSetBuilder = ConstraintSetBuilder.newBuilder(context);
        Intrinsics.checkNotNullExpressionValue((Object)constraintSetBuilder, (String)"newBuilder(context)");
        ConstraintSetBuilder constraints = constraintSetBuilder;
        ScoreStyle style = model.getStyle();
        if (WhenMappings.$EnumSwitchMapping$0[style.getType().ordinal()] == 1) {
            Intrinsics.checkNotNull((Object)style, (String)"null cannot be cast to non-null type com.urbanairship.android.layout.property.ScoreStyle.NumberRange");
            this.configureNumberRange((ScoreStyle.NumberRange)style, constraints);
        }
        constraints.build().applyTo((ConstraintLayout)this);
        StringExtensionsKt.ifNotEmpty(model.getContentDescription(), (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(){

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.setContentDescription(it);
            }
        }));
        model.setListener$urbanairship_layout_release((BaseModel.Listener)new ScoreModel.Listener(){

            @Override
            public void onSetSelectedScore(@Nullable Integer value) {
                block0: {
                    Integer n = value;
                    if (n == null) break block0;
                    Integer n2 = n;
                    ScoreView scoreView = this;
                    int it = ((Number)n2).intValue();
                    boolean bl = false;
                    scoreView.setSelectedScore(it);
                }
            }

            @Override
            public void setEnabled(boolean enabled) {
                this.updateEnabledState(enabled);
            }

            @Override
            public void setVisibility(boolean visible) {
                View $this$isGone$iv = (View)this;
                boolean $i$f$setGone = false;
                $this$isGone$iv.setVisibility(visible ? 8 : 0);
            }
        });
    }

    @Nullable
    public final OnScoreSelectedListener getScoreSelectedListener() {
        return this.scoreSelectedListener;
    }

    public final void setScoreSelectedListener(@Nullable OnScoreSelectedListener onScoreSelectedListener) {
        this.scoreSelectedListener = onScoreSelectedListener;
    }

    private final void configureNumberRange(ScoreStyle.NumberRange style, ConstraintSetBuilder constraints) {
        ScoreStyle.Bindings bindings = style.getBindings();
        Intrinsics.checkNotNullExpressionValue((Object)bindings, (String)"style.bindings");
        ScoreStyle.Bindings bindings2 = bindings;
        int start = style.getStart();
        int end = style.getEnd();
        int[] viewIds = new int[end - start + 1];
        int i = start;
        if (i <= end) {
            while (true) {
                Context context = this.getContext();
                List<Shape> list = bindings2.getSelected().getShapes();
                List<Shape> list2 = bindings2.getUnselected().getShapes();
                String string = String.valueOf(i);
                TextAppearance textAppearance = bindings2.getSelected().getTextAppearance();
                TextAppearance textAppearance2 = bindings2.getUnselected().getTextAppearance();
                ShapeButton button2 = new ShapeButton(context, list, list2, string, textAppearance, textAppearance2){

                    public void toggle() {
                    }
                };
                int viewId = View.generateViewId();
                button2.setId(viewId);
                viewIds[i - start] = viewId;
                this.scoreToViewIds.append(i, viewId);
                button2.setOnClickListener(arg_0 -> ScoreView.configureNumberRange$lambda-0(this, i, arg_0));
                constraints.squareAspectRatio(viewId);
                constraints.minHeight(viewId, 16);
                this.addView((View)button2, (ViewGroup.LayoutParams)new ConstraintLayout.LayoutParams(0, 0));
                if (i == end) break;
                ++i;
            }
        }
        constraints.setHorizontalChainStyle(viewIds, 2).createHorizontalChainInParent(viewIds, 0, style.getSpacing());
    }

    public final void setSelectedScore(@Nullable Integer score) {
        block2: {
            block1: {
                this.selectedScore = score;
                if (score == null) break block1;
                int viewId = this.scoreToViewIds.get(score.intValue(), -1);
                if (viewId <= -1) break block2;
                View view = this.findViewById(viewId);
                Checkable checkable = view instanceof Checkable ? (Checkable)view : null;
                if (checkable == null) break block2;
                checkable.setChecked(true);
                break block2;
            }
            int n = this.getChildCount();
            for (int i = 0; i < n; ++i) {
                View child = this.getChildAt(i);
                Checkable checkable = child instanceof Checkable ? (Checkable)child : null;
                if (checkable == null) continue;
                checkable.setChecked(false);
            }
        }
    }

    private final void onScoreClick(View view, int score) {
        block6: {
            block5: {
                if (!this.isEnabled) break block5;
                Integer n = this.selectedScore;
                if (n == null || score != n) break block6;
            }
            return;
        }
        this.selectedScore = score;
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            View child = this.getChildAt(i);
            Checkable checkable = child instanceof Checkable ? (Checkable)child : null;
            if (checkable == null) continue;
            checkable.setChecked(view.getId() == child.getId());
        }
        OnScoreSelectedListener onScoreSelectedListener = this.scoreSelectedListener;
        if (onScoreSelectedListener != null) {
            onScoreSelectedListener.onScoreSelected(score);
        }
        this.clicksChannel.trySend-JP2dKIU((Object)Unit.INSTANCE);
    }

    private final void updateEnabledState(boolean enabled) {
        this.isEnabled = enabled;
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            this.getChildAt(i).setEnabled(enabled);
        }
    }

    @Override
    @NotNull
    public Flow<Unit> taps() {
        return FlowKt.receiveAsFlow((ReceiveChannel)((ReceiveChannel)this.clicksChannel));
    }

    private static final void configureNumberRange$lambda-0(ScoreView this$0, int $i, View v) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        this$0.onScoreClick(v, $i);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/urbanairship/android/layout/view/ScoreView$OnScoreSelectedListener;", "", "onScoreSelected", "", "score", "", "urbanairship-layout_release"})
    public static interface OnScoreSelectedListener {
        public void onScoreSelected(int var1);
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ScoreType.values().length];
            nArray[ScoreType.NUMBER_RANGE.ordinal()] = 1;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

