/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.widget;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.view.View;
import android.widget.Checkable;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.urbanairship.android.layout.property.Image;
import com.urbanairship.android.layout.shape.Shape;
import com.urbanairship.android.layout.widget.Clippable;
import com.urbanairship.android.layout.widget.ClippableViewDelegate;
import java.util.List;

public class ShapeView
extends ImageView
implements Checkable,
Clippable {
    private static final int[] CHECKED_STATE_SET = new int[]{0x10100A0};
    private final ClippableViewDelegate clippableViewDelegate = new ClippableViewDelegate();
    private boolean isChecked = false;

    public ShapeView(Context context, List<Shape> checkedShapes, List<Shape> uncheckedShapes) {
        this(context, checkedShapes, uncheckedShapes, null, null);
    }

    public ShapeView(Context context, @NonNull List<Shape> checkedShapes, @NonNull List<Shape> uncheckedShapes, @Nullable Image.Icon checkedIcon, @Nullable Image.Icon uncheckedIcon) {
        super(context);
        this.setId(ShapeView.generateViewId());
        this.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
        StateListDrawable drawable2 = Shape.buildStateListDrawable(context, checkedShapes, uncheckedShapes, checkedIcon, uncheckedIcon);
        this.setImageDrawable((Drawable)drawable2);
    }

    public void setChecked(boolean checked) {
        if (checked != this.isChecked) {
            this.isChecked = checked;
            this.refreshDrawableState();
        }
    }

    public boolean isChecked() {
        return this.isChecked;
    }

    public void toggle() {
        this.setChecked(!this.isChecked);
    }

    public int[] onCreateDrawableState(int extraSpace) {
        int[] drawableState = super.onCreateDrawableState(extraSpace + 1);
        if (this.isChecked()) {
            ShapeView.mergeDrawableStates((int[])drawableState, (int[])CHECKED_STATE_SET);
        }
        return drawableState;
    }

    @Override
    public void setClipPathBorderRadius(float borderRadius) {
        this.clippableViewDelegate.setClipPathBorderRadius((View)this, borderRadius);
    }
}

