/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout;

import com.urbanairship.android.layout.ModelFactory;
import com.urbanairship.android.layout.ModelFactoryException;
import com.urbanairship.android.layout.ThomasModelFactory;
import com.urbanairship.android.layout.environment.FormType;
import com.urbanairship.android.layout.environment.LayoutState;
import com.urbanairship.android.layout.environment.ModelEnvironment;
import com.urbanairship.android.layout.environment.SharedState;
import com.urbanairship.android.layout.environment.State;
import com.urbanairship.android.layout.info.CheckboxControllerInfo;
import com.urbanairship.android.layout.info.CheckboxInfo;
import com.urbanairship.android.layout.info.ContainerLayoutInfo;
import com.urbanairship.android.layout.info.ContainerLayoutItemInfo;
import com.urbanairship.android.layout.info.EmptyInfo;
import com.urbanairship.android.layout.info.FormControllerInfo;
import com.urbanairship.android.layout.info.ImageButtonInfo;
import com.urbanairship.android.layout.info.ItemInfo;
import com.urbanairship.android.layout.info.LabelButtonInfo;
import com.urbanairship.android.layout.info.LabelInfo;
import com.urbanairship.android.layout.info.LinearLayoutInfo;
import com.urbanairship.android.layout.info.LinearLayoutItemInfo;
import com.urbanairship.android.layout.info.MediaInfo;
import com.urbanairship.android.layout.info.NpsFormControllerInfo;
import com.urbanairship.android.layout.info.PagerControllerInfo;
import com.urbanairship.android.layout.info.PagerIndicatorInfo;
import com.urbanairship.android.layout.info.PagerInfo;
import com.urbanairship.android.layout.info.PagerItemInfo;
import com.urbanairship.android.layout.info.RadioInputControllerInfo;
import com.urbanairship.android.layout.info.RadioInputInfo;
import com.urbanairship.android.layout.info.ScoreInfo;
import com.urbanairship.android.layout.info.ScrollLayoutInfo;
import com.urbanairship.android.layout.info.StateControllerInfo;
import com.urbanairship.android.layout.info.StoryIndicatorInfo;
import com.urbanairship.android.layout.info.TextInputInfo;
import com.urbanairship.android.layout.info.ToggleInfo;
import com.urbanairship.android.layout.info.ViewGroupInfo;
import com.urbanairship.android.layout.info.ViewInfo;
import com.urbanairship.android.layout.info.WebViewInfo;
import com.urbanairship.android.layout.model.BaseModel;
import com.urbanairship.android.layout.model.CheckboxController;
import com.urbanairship.android.layout.model.CheckboxModel;
import com.urbanairship.android.layout.model.ContainerLayoutModel;
import com.urbanairship.android.layout.model.EmptyModel;
import com.urbanairship.android.layout.model.FormController;
import com.urbanairship.android.layout.model.ImageButtonModel;
import com.urbanairship.android.layout.model.LabelButtonModel;
import com.urbanairship.android.layout.model.LabelModel;
import com.urbanairship.android.layout.model.LinearLayoutModel;
import com.urbanairship.android.layout.model.MediaModel;
import com.urbanairship.android.layout.model.ModelProperties;
import com.urbanairship.android.layout.model.NpsFormController;
import com.urbanairship.android.layout.model.PagerController;
import com.urbanairship.android.layout.model.PagerIndicatorModel;
import com.urbanairship.android.layout.model.PagerModel;
import com.urbanairship.android.layout.model.RadioInputController;
import com.urbanairship.android.layout.model.RadioInputModel;
import com.urbanairship.android.layout.model.ScoreModel;
import com.urbanairship.android.layout.model.ScrollLayoutModel;
import com.urbanairship.android.layout.model.StateController;
import com.urbanairship.android.layout.model.StoryIndicatorModel;
import com.urbanairship.android.layout.model.TextInputModel;
import com.urbanairship.android.layout.model.ToggleModel;
import com.urbanairship.android.layout.model.WebViewModel;
import com.urbanairship.android.layout.property.ViewType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0002%&B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\r\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000ej\u0002`\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J$\u0010\u0012\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000ej\u0002`\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0014\u0010\u0018\u001a\u00060\u0005j\u0002`\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0002JR\u0010\u0019\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000ej\u0002`\u000f2\u0006\u0010\u001a\u001a\u00020\u001b2$\u0010\u001c\u001a \u0012\u001c\u0012\u001a\u0012\u0010\u0012\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000ej\u0002`\u000f\u0012\u0004\u0012\u00020\u001f0\u001e0\u001d2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0014H\u0002R\u001e\u0010\u0003\u001a\u0012\u0012\b\u0012\u00060\u0005j\u0002`\u0006\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\b\u0012\u00060\u0005j\u0002`\u0006\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00060\u0005j\u0002`\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/urbanairship/android/layout/ThomasModelFactory;", "Lcom/urbanairship/android/layout/ModelFactory;", "()V", "processedControllers", "", "", "Lcom/urbanairship/android/layout/Tag;", "Lcom/urbanairship/android/layout/ThomasModelFactory$LayoutNode$Builder;", "processedNodes", "rootTag", "tagIndexMap", "Lcom/urbanairship/android/layout/property/ViewType;", "", "build", "Lcom/urbanairship/android/layout/model/BaseModel;", "Lcom/urbanairship/android/layout/model/AnyModel;", "environment", "Lcom/urbanairship/android/layout/environment/ModelEnvironment;", "create", "info", "Lcom/urbanairship/android/layout/info/ViewInfo;", "createMutableSharedState", "Lcom/urbanairship/android/layout/environment/SharedState;", "Lcom/urbanairship/android/layout/environment/State;", "generateTag", "model", "node", "Lcom/urbanairship/android/layout/ThomasModelFactory$LayoutNode;", "children", "", "Lkotlin/Pair;", "Lcom/urbanairship/android/layout/info/ItemInfo;", "properties", "Lcom/urbanairship/android/layout/model/ModelProperties;", "process", "", "root", "Controllers", "LayoutNode", "urbanairship-layout_release"})
public final class ThomasModelFactory
implements ModelFactory {
    @NotNull
    private final Map<String, LayoutNode.Builder> processedControllers = new LinkedHashMap();
    @NotNull
    private final Map<String, LayoutNode.Builder> processedNodes = new LinkedHashMap();
    @NotNull
    private final Map<ViewType, Integer> tagIndexMap = new LinkedHashMap();
    private String rootTag;

    @Override
    @NotNull
    public BaseModel<?, ?> create(@NotNull ViewInfo info, @NotNull ModelEnvironment environment) throws ModelFactoryException {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        this.rootTag = this.generateTag(info);
        this.process(info);
        return this.build(environment);
    }

    private final String generateTag(ViewInfo info) {
        Map<ViewType, Integer> map2 = this.tagIndexMap;
        Integer n = map2.get((Object)info.getType());
        if (n == null) {
            boolean bl = false;
            n = 0;
        }
        map2 = n;
        int it = ((Number)((Object)map2)).intValue();
        boolean bl = false;
        this.tagIndexMap.put(info.getType(), it + 1);
        int id = ((Number)((Object)map2)).intValue();
        return "" + (Object)((Object)info.getType()) + '_' + id;
    }

    private final void process(ViewInfo root) {
        ArrayDeque stack = new ArrayDeque();
        Controllers.Builder emptyControllers = new Controllers.Builder(null, null, null, null, null, null, 63, null);
        String string = this.rootTag;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rootTag");
            string = null;
        }
        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00005\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002*\u0001\u0000\b\u008a\b\u0018\u00002\u00020\u0001B;\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\u000e\u0010\u0005\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u000bJ\r\u0010\u0014\u001a\u00060\u0003j\u0002`\u0004H\u00c6\u0003J\u0011\u0010\u0015\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u0004H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\tH\u00c6\u0003J\u000b\u0010\u0018\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003JN\u0010\u0019\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u00060\u0003j\u0002`\u00042\u0010\b\u0002\u0010\u0005\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u001aJ\u0013\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\n\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0019\u0010\u0005\u001a\n\u0018\u00010\u0003j\u0004\u0018\u0001`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011\u00a8\u0006!"}, d2={"com/urbanairship/android/layout/ThomasModelFactory$process$StackEntry", "", "tag", "", "Lcom/urbanairship/android/layout/Tag;", "parentTag", "info", "Lcom/urbanairship/android/layout/info/ItemInfo;", "controllers", "Lcom/urbanairship/android/layout/ThomasModelFactory$Controllers$Builder;", "pagerPageId", "(Ljava/lang/String;Ljava/lang/String;Lcom/urbanairship/android/layout/info/ItemInfo;Lcom/urbanairship/android/layout/ThomasModelFactory$Controllers$Builder;Ljava/lang/String;)V", "getControllers", "()Lcom/urbanairship/android/layout/ThomasModelFactory$Controllers$Builder;", "getInfo", "()Lcom/urbanairship/android/layout/info/ItemInfo;", "getPagerPageId", "()Ljava/lang/String;", "getParentTag", "getTag", "component1", "component2", "component3", "component4", "component5", "copy", "(Ljava/lang/String;Ljava/lang/String;Lcom/urbanairship/android/layout/info/ItemInfo;Lcom/urbanairship/android/layout/ThomasModelFactory$Controllers$Builder;Ljava/lang/String;)Lcom/urbanairship/android/layout/ThomasModelFactory$process$StackEntry;", "equals", "", "other", "hashCode", "", "toString", "urbanairship-layout_release"})
        public final class StackEntry {
            @NotNull
            private final String tag;
            @Nullable
            private final String parentTag;
            @NotNull
            private final ItemInfo info;
            @NotNull
            private final Controllers.Builder controllers;
            @Nullable
            private final String pagerPageId;

            public StackEntry(@NotNull String tag, @Nullable String parentTag, @NotNull ItemInfo info, @NotNull Controllers.Builder controllers, @Nullable String pagerPageId) {
                Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                Intrinsics.checkNotNullParameter((Object)controllers, (String)"controllers");
                this.tag = tag;
                this.parentTag = parentTag;
                this.info = info;
                this.controllers = controllers;
                this.pagerPageId = pagerPageId;
            }

            @NotNull
            public final String getTag() {
                return this.tag;
            }

            @Nullable
            public final String getParentTag() {
                return this.parentTag;
            }

            @NotNull
            public final ItemInfo getInfo() {
                return this.info;
            }

            @NotNull
            public final Controllers.Builder getControllers() {
                return this.controllers;
            }

            @Nullable
            public final String getPagerPageId() {
                return this.pagerPageId;
            }

            @NotNull
            public final String component1() {
                return this.tag;
            }

            @Nullable
            public final String component2() {
                return this.parentTag;
            }

            @NotNull
            public final ItemInfo component3() {
                return this.info;
            }

            @NotNull
            public final Controllers.Builder component4() {
                return this.controllers;
            }

            @Nullable
            public final String component5() {
                return this.pagerPageId;
            }

            @NotNull
            public final StackEntry copy(@NotNull String tag, @Nullable String parentTag, @NotNull ItemInfo info, @NotNull Controllers.Builder controllers, @Nullable String pagerPageId) {
                Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                Intrinsics.checkNotNullParameter((Object)controllers, (String)"controllers");
                return new StackEntry(tag, parentTag, info, controllers, pagerPageId);
            }

            public static /* synthetic */ StackEntry copy$default(StackEntry stackEntry, String string, String string2, ItemInfo itemInfo, Controllers.Builder builder, String string3, int n, Object object) {
                if ((n & 1) != 0) {
                    string = stackEntry.tag;
                }
                if ((n & 2) != 0) {
                    string2 = stackEntry.parentTag;
                }
                if ((n & 4) != 0) {
                    itemInfo = stackEntry.info;
                }
                if ((n & 8) != 0) {
                    builder = stackEntry.controllers;
                }
                if ((n & 0x10) != 0) {
                    string3 = stackEntry.pagerPageId;
                }
                return stackEntry.copy(string, string2, itemInfo, builder, string3);
            }

            @NotNull
            public String toString() {
                return "StackEntry(tag=" + this.tag + ", parentTag=" + this.parentTag + ", info=" + this.info + ", controllers=" + this.controllers + ", pagerPageId=" + this.pagerPageId + ')';
            }

            public int hashCode() {
                int result = this.tag.hashCode();
                result = result * 31 + (this.parentTag == null ? 0 : this.parentTag.hashCode());
                result = result * 31 + this.info.hashCode();
                result = result * 31 + this.controllers.hashCode();
                result = result * 31 + (this.pagerPageId == null ? 0 : this.pagerPageId.hashCode());
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof StackEntry)) {
                    return false;
                }
                StackEntry stackEntry = (StackEntry)other;
                if (!Intrinsics.areEqual((Object)this.tag, (Object)stackEntry.tag)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.parentTag, (Object)stackEntry.parentTag)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.info, (Object)stackEntry.info)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.controllers, (Object)stackEntry.controllers)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.pagerPageId, (Object)stackEntry.pagerPageId);
            }
        }
        stack.addFirst((Object)new StackEntry(string, null, new ItemInfo.ViewItemInfo(root), emptyControllers, null));
        while (!((Collection)stack).isEmpty()) {
            Controllers.Builder builder;
            Object object;
            StackEntry stackEntry = (StackEntry)stack.removeFirst();
            String tag = stackEntry.component1();
            String parentTag = stackEntry.component2();
            ItemInfo info = stackEntry.component3();
            Controllers.Builder controllers = stackEntry.component4();
            String pagerPageId = stackEntry.component5();
            LayoutNode.Builder node = new LayoutNode.Builder(tag, info, null, null, controllers, pagerPageId, 12, null);
            CharSequence charSequence = parentTag;
            if (!(charSequence == null || charSequence.length() == 0) && (object = this.processedNodes.get(parentTag)) != null && (object = ((LayoutNode.Builder)object).getChildTags()) != null) {
                object.add(node.getTag());
            }
            if (info.getType().isController()) {
                Controllers.Builder builder2;
                Controllers.Builder it = builder2 = controllers.update(info.getType(), tag);
                boolean bl = false;
                this.processedControllers.put(tag, node);
                node.setControllers(node.getControllers().update(info.getType(), tag));
                builder = builder2;
            } else {
                builder = controllers;
            }
            Controllers.Builder childControllers = builder;
            this.processedNodes.put(tag, node);
            if (!(info.getInfo() instanceof ViewGroupInfo)) continue;
            List children = ((ViewGroupInfo)info.getInfo()).getChildren();
            for (int i = children.size() - 1; -1 < i; --i) {
                ItemInfo child = (ItemInfo)children.get(i);
                String string2 = this.generateTag(child.getInfo());
                String string3 = pagerPageId;
                if (string3 == null) {
                    PagerItemInfo pagerItemInfo = child instanceof PagerItemInfo ? (PagerItemInfo)child : null;
                    string3 = pagerItemInfo != null ? pagerItemInfo.getIdentifier() : null;
                }
                stack.addFirst((Object)new StackEntry(string2, tag, child, childControllers, string3));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final BaseModel<?, ?> build(ModelEnvironment environment) throws ModelFactoryException {
        void $this$mapValuesTo$iv$iv;
        Object object;
        Map it;
        Object object2;
        Object k;
        void $this$mapValuesTo$iv$iv2;
        Map<String, LayoutNode.Builder> $this$mapValues$iv = this.processedControllers;
        boolean $i$f$mapValues = false;
        Map<String, LayoutNode.Builder> map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo22 = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv2.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            Iterator it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            k = it$iv$iv.getKey();
            object2 = map3;
            boolean bl2 = false;
            object = ((LayoutNode.Builder)it.getValue()).build();
            object2.put(k, object);
        }
        Map controllers = destination$iv$iv;
        Map builtModels = new LinkedHashMap();
        Map $this$mapValues$iv2 = controllers;
        boolean $i$f$mapValues22 = false;
        Map $i$f$mapValuesTo22 = $this$mapValues$iv2;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv2.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv2 = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo2 = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv2) {
            void it$iv$iv;
            Map.Entry bl = (Map.Entry)element$iv$iv$iv;
            it = destination$iv$iv2;
            boolean $i$a$-associateByTo-MapsKt__MapsKt$mapValuesTo$1$iv$iv2 = false;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            k = it$iv$iv.getKey();
            object2 = it;
            boolean bl3 = false;
            LayoutNode ctrl = (LayoutNode)entry.getValue();
            object = this.createMutableSharedState(ctrl.getInfo().getInfo());
            object2.put(k, object);
        }
        Map layoutStates = destination$iv$iv2;
        while (!this.processedNodes.isEmpty()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object it2;
            void $this$filterTo$iv$iv;
            Map $this$filter$iv;
            Map<String, LayoutNode.Builder> $i$f$mapValues22 = this.processedNodes;
            boolean $i$f$filter = false;
            destination$iv$iv2 = $this$filter$iv;
            Object destination$iv$iv3 = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            for (Map.Entry element$iv$iv : $this$filterTo$iv$iv.entrySet()) {
                it2 = element$iv$iv;
                boolean bl = false;
                if (!(((LayoutNode.Builder)it2.getValue()).getChildTags().isEmpty() || builtModels.keySet().containsAll((Collection)((LayoutNode.Builder)it2.getValue()).getChildTags()))) continue;
                destination$iv$iv3.put(element$iv$iv.getKey(), element$iv$iv.getValue());
            }
            $this$filter$iv = destination$iv$iv3;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv3 = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
                it2 = item$iv$iv;
                object2 = destination$iv$iv3;
                boolean bl = false;
                object2.add(TuplesKt.to(it2.getKey(), (Object)((LayoutNode.Builder)it2.getValue()).build()));
            }
            List leaves = (List)destination$iv$iv3;
            for (Pair pair : leaves) {
                void $this$mapTo$iv$iv2;
                String tag = (String)pair.component1();
                LayoutNode node = (LayoutNode)pair.component2();
                Iterable $this$map$iv2 = node.getChildTags();
                boolean $i$f$map2 = false;
                it2 = $this$map$iv2;
                Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                    void it3;
                    String bl3 = (String)item$iv$iv;
                    object2 = destination$iv$iv4;
                    boolean bl = false;
                    Pair pair2 = (Pair)builtModels.get(it3);
                    if (pair2 == null) {
                        throw new ModelFactoryException("Unable to build model. Child with tag '" + (String)it3 + "' is not built yet!");
                    }
                    object2.add(pair2);
                }
                List children = (List)destination$iv$iv4;
                ModelEnvironment childEnvironment = environment.withState(node.getControllers().buildLayoutState(layoutStates));
                ModelProperties properties = new ModelProperties(node.getPagerPageId());
                BaseModel<?, ?> model = this.model(node, children, childEnvironment, properties);
                builtModels.put(tag, new Pair(model, (Object)node.getInfo()));
                this.processedNodes.remove(tag);
            }
        }
        String string = this.rootTag;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"rootTag");
            string = null;
        }
        Pair pair = (Pair)builtModels.get(string);
        if (pair == null) {
            throw new ModelFactoryException("Failed to build models. Root model not found!");
        }
        Pair root = pair;
        return (BaseModel)root.getFirst();
    }

    private final SharedState<State> createMutableSharedState(ViewInfo info) {
        ViewInfo viewInfo = info;
        return viewInfo instanceof FormControllerInfo ? new SharedState<State.Form>(new State.Form(((FormControllerInfo)info).getIdentifier(), FormType.Form.INSTANCE, ((FormControllerInfo)info).getResponseType(), null, null, null, false, false, false, false, 1016, null)) : (viewInfo instanceof NpsFormControllerInfo ? new SharedState<State.Form>(new State.Form(((NpsFormControllerInfo)info).getIdentifier(), new FormType.Nps(((NpsFormControllerInfo)info).getNpsIdentifier()), ((NpsFormControllerInfo)info).getResponseType(), null, null, null, false, false, false, false, 1016, null)) : (viewInfo instanceof RadioInputControllerInfo ? new SharedState<State.Radio>(new State.Radio(((RadioInputControllerInfo)info).getIdentifier(), null, null, false, 14, null)) : (viewInfo instanceof CheckboxControllerInfo ? new SharedState<State.Checkbox>(new State.Checkbox(((CheckboxControllerInfo)info).getIdentifier(), ((CheckboxControllerInfo)info).getMinSelection(), ((CheckboxControllerInfo)info).getMaxSelection(), null, false, 24, null)) : (viewInfo instanceof PagerControllerInfo ? new SharedState<State.Pager>(new State.Pager(((PagerControllerInfo)info).getIdentifier(), 0, 0, false, null, null, 0, 126, null)) : (viewInfo instanceof StateControllerInfo ? new SharedState<State.Layout>(new State.Layout(null, 1, null)) : null)))));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final BaseModel<?, ?> model(LayoutNode node, List<? extends Pair<? extends BaseModel<?, ?>, ? extends ItemInfo>> children, ModelEnvironment environment, ModelProperties properties) throws ModelFactoryException {
        BaseModel baseModel;
        ViewInfo info = node.getInfo().getInfo();
        if (info instanceof ViewGroupInfo) {
            ViewGroupInfo viewGroupInfo = (ViewGroupInfo)info;
            if (viewGroupInfo instanceof ContainerLayoutInfo) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Iterable iterable = children;
                ContainerLayoutInfo containerLayoutInfo = (ContainerLayoutInfo)info;
                boolean $i$f$map = false;
                void var9_16 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    ContainerLayoutItemInfo it;
                    Pair pair = (Pair)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    BaseModel model = (BaseModel)pair.component1();
                    ItemInfo itemInfo = (ItemInfo)pair.component2();
                    if ((itemInfo instanceof ContainerLayoutItemInfo ? (ContainerLayoutItemInfo)itemInfo : null) == null) {
                        throw new ModelFactoryException("ContainerLayoutItemInfo expected");
                    }
                    it = it;
                    boolean bl2 = false;
                    collection.add(new ContainerLayoutModel.Item(it, model));
                }
                ModelProperties modelProperties = properties;
                ModelEnvironment modelEnvironment = environment;
                List list = (List)destination$iv$iv;
                ContainerLayoutInfo containerLayoutInfo2 = containerLayoutInfo;
                baseModel = new ContainerLayoutModel(containerLayoutInfo2, list, modelEnvironment, modelProperties);
                return baseModel;
            } else if (viewGroupInfo instanceof LinearLayoutInfo) {
                Iterable $this$map$iv = children;
                LinearLayoutInfo linearLayoutInfo = (LinearLayoutInfo)info;
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    LinearLayoutItemInfo it;
                    Pair pair = (Pair)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    BaseModel model = (BaseModel)pair.component1();
                    ItemInfo itemInfo = (ItemInfo)pair.component2();
                    if ((itemInfo instanceof LinearLayoutItemInfo ? (LinearLayoutItemInfo)itemInfo : null) == null) {
                        throw new ModelFactoryException("LinearLayoutItemInfo expected");
                    }
                    it = it;
                    boolean bl3 = false;
                    collection.add(new LinearLayoutModel.Item(it, model));
                }
                ModelProperties modelProperties = properties;
                ModelEnvironment modelEnvironment = environment;
                List list = (List)destination$iv$iv;
                LinearLayoutInfo linearLayoutInfo2 = linearLayoutInfo;
                baseModel = new LinearLayoutModel(linearLayoutInfo2, list, modelEnvironment, modelProperties);
                return baseModel;
            } else if (viewGroupInfo instanceof PagerInfo) {
                Iterable $this$map$iv = children;
                PagerInfo pagerInfo = (PagerInfo)info;
                boolean $i$f$map = false;
                Iterable $this$mapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    PagerItemInfo it;
                    Pair pair = (Pair)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    BaseModel model = (BaseModel)pair.component1();
                    ItemInfo itemInfo = (ItemInfo)pair.component2();
                    if ((itemInfo instanceof PagerItemInfo ? (PagerItemInfo)itemInfo : null) == null) {
                        throw new ModelFactoryException("PagerItemInfo expected");
                    }
                    it = it;
                    boolean bl4 = false;
                    collection.add(new PagerModel.Item(model, ((PagerItemInfo)itemInfo).getIdentifier(), ((PagerItemInfo)itemInfo).getDisplayActions(), ((PagerItemInfo)itemInfo).getAutomatedActions()));
                }
                SharedState<State.Pager> sharedState = environment.getLayoutState().getPager();
                if (sharedState == null) {
                    throw new ModelFactoryException("Required pager state was null for PagerController!");
                }
                ModelProperties modelProperties = properties;
                ModelEnvironment modelEnvironment = environment;
                SharedState<State.Pager> sharedState2 = sharedState;
                List list = (List)destination$iv$iv;
                PagerInfo pagerInfo2 = pagerInfo;
                baseModel = new PagerModel(pagerInfo2, list, sharedState2, modelEnvironment, modelProperties);
                return baseModel;
            } else if (viewGroupInfo instanceof ScrollLayoutInfo) {
                baseModel = new ScrollLayoutModel((ScrollLayoutInfo)info, (BaseModel)((Pair)CollectionsKt.first(children)).getFirst(), environment, properties);
                return baseModel;
            } else if (viewGroupInfo instanceof FormControllerInfo) {
                SharedState<State.Form> sharedState = environment.getLayoutState().getForm();
                if (sharedState == null) {
                    throw new ModelFactoryException("Required form state was null for FormController!");
                }
                baseModel = new FormController((FormControllerInfo)info, (BaseModel)((Pair)CollectionsKt.first(children)).getFirst(), sharedState, environment.getLayoutState().getParentForm(), environment.getLayoutState().getPager(), environment, properties);
                return baseModel;
            } else if (viewGroupInfo instanceof NpsFormControllerInfo) {
                SharedState<State.Form> sharedState = environment.getLayoutState().getForm();
                if (sharedState == null) {
                    throw new ModelFactoryException("Required form state was null for NpsFormController!");
                }
                baseModel = new NpsFormController((NpsFormControllerInfo)info, (BaseModel)((Pair)CollectionsKt.first(children)).getFirst(), sharedState, environment.getLayoutState().getParentForm(), environment.getLayoutState().getPager(), environment, properties);
                return baseModel;
            } else if (viewGroupInfo instanceof PagerControllerInfo) {
                SharedState<State.Pager> sharedState = environment.getLayoutState().getPager();
                if (sharedState == null) {
                    throw new ModelFactoryException("Required pager state was null for PagerController!");
                }
                baseModel = new PagerController((PagerControllerInfo)info, (BaseModel)((Pair)CollectionsKt.first(children)).getFirst(), sharedState, environment, properties);
                return baseModel;
            } else if (viewGroupInfo instanceof CheckboxControllerInfo) {
                SharedState<State.Form> sharedState = environment.getLayoutState().getForm();
                if (sharedState == null) {
                    throw new ModelFactoryException("Required form state was null for CheckboxController!");
                }
                SharedState<State.Checkbox> sharedState3 = environment.getLayoutState().getCheckbox();
                if (sharedState3 == null) {
                    throw new ModelFactoryException("Required checkbox state was null for CheckboxController!");
                }
                baseModel = new CheckboxController((CheckboxControllerInfo)info, (BaseModel)((Pair)CollectionsKt.first(children)).getFirst(), sharedState, sharedState3, environment, properties);
                return baseModel;
            } else if (viewGroupInfo instanceof RadioInputControllerInfo) {
                SharedState<State.Form> sharedState = environment.getLayoutState().getForm();
                if (sharedState == null) {
                    throw new ModelFactoryException("Required form state was null for RadioInputController!");
                }
                SharedState<State.Radio> sharedState4 = environment.getLayoutState().getRadio();
                if (sharedState4 == null) {
                    throw new ModelFactoryException("Required radio state was null for RadioInputController!");
                }
                baseModel = new RadioInputController((RadioInputControllerInfo)info, (BaseModel)((Pair)CollectionsKt.first(children)).getFirst(), sharedState, sharedState4, environment, properties);
                return baseModel;
            } else {
                if (!(viewGroupInfo instanceof StateControllerInfo)) throw new ModelFactoryException("Unsupported view type: " + info.getClass().getName());
                baseModel = new StateController((StateControllerInfo)info, (BaseModel)((Pair)CollectionsKt.first(children)).getFirst(), environment, properties);
            }
            return baseModel;
        } else if (info instanceof EmptyInfo) {
            baseModel = new EmptyModel((EmptyInfo)info, environment, properties);
            return baseModel;
        } else if (info instanceof WebViewInfo) {
            baseModel = new WebViewModel((WebViewInfo)info, environment, properties);
            return baseModel;
        } else if (info instanceof MediaInfo) {
            baseModel = new MediaModel((MediaInfo)info, environment, properties);
            return baseModel;
        } else if (info instanceof LabelInfo) {
            baseModel = new LabelModel((LabelInfo)info, environment, properties);
            return baseModel;
        } else if (info instanceof LabelButtonInfo) {
            baseModel = new LabelButtonModel((LabelButtonInfo)info, new LabelModel(((LabelButtonInfo)info).getLabel(), environment, properties), environment.getLayoutState().getForm(), environment.getLayoutState().getPager(), environment, properties);
            return baseModel;
        } else if (info instanceof ImageButtonInfo) {
            baseModel = new ImageButtonModel((ImageButtonInfo)info, environment.getLayoutState().getForm(), environment.getLayoutState().getPager(), environment, properties);
            return baseModel;
        } else if (info instanceof PagerIndicatorInfo) {
            baseModel = new PagerIndicatorModel((PagerIndicatorInfo)info, environment, properties);
            return baseModel;
        } else if (info instanceof StoryIndicatorInfo) {
            baseModel = new StoryIndicatorModel((StoryIndicatorInfo)info, environment, properties);
            return baseModel;
        } else if (info instanceof CheckboxInfo) {
            SharedState<State.Checkbox> sharedState = environment.getLayoutState().getCheckbox();
            if (sharedState == null) {
                throw new ModelFactoryException("Required checkbox state was null for CheckboxModel!");
            }
            SharedState<State.Form> sharedState5 = environment.getLayoutState().getForm();
            if (sharedState5 == null) {
                throw new ModelFactoryException("Required form state was null for CheckboxModel!");
            }
            baseModel = new CheckboxModel((CheckboxInfo)info, sharedState, sharedState5, environment, properties);
            return baseModel;
        } else if (info instanceof ToggleInfo) {
            SharedState<State.Form> sharedState = environment.getLayoutState().getForm();
            if (sharedState == null) {
                throw new ModelFactoryException("Required form state was null for ToggleModel!");
            }
            baseModel = new ToggleModel((ToggleInfo)info, sharedState, environment, properties);
            return baseModel;
        } else if (info instanceof RadioInputInfo) {
            SharedState<State.Radio> sharedState = environment.getLayoutState().getRadio();
            if (sharedState == null) {
                throw new ModelFactoryException("Required radio state was null for RadioInputModel!");
            }
            SharedState<State.Form> sharedState6 = environment.getLayoutState().getForm();
            if (sharedState6 == null) {
                throw new ModelFactoryException("Required form state was null for RadioInputModel!");
            }
            baseModel = new RadioInputModel((RadioInputInfo)info, sharedState, sharedState6, environment, properties);
            return baseModel;
        } else if (info instanceof TextInputInfo) {
            SharedState<State.Form> sharedState = environment.getLayoutState().getForm();
            if (sharedState == null) {
                throw new ModelFactoryException("Required form state was null for TextInputModel!");
            }
            baseModel = new TextInputModel((TextInputInfo)info, sharedState, environment, properties);
            return baseModel;
        } else {
            if (!(info instanceof ScoreInfo)) throw new ModelFactoryException("Unsupported view type: " + info.getClass().getName());
            SharedState<State.Form> sharedState = environment.getLayoutState().getForm();
            if (sharedState == null) {
                throw new ModelFactoryException("Required form state was null for ScoreModel!");
            }
            baseModel = new ScoreModel((ScoreInfo)info, sharedState, environment, properties);
        }
        return baseModel;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0001\"B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0010\u0010\u0006\u001a\f\u0012\b\u0012\u00060\u0003j\u0002`\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\u0013\u0010\u0018\u001a\f\u0012\b\u0012\u00060\u0003j\u0002`\b0\u0007H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\nH\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003JG\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u0012\b\u0002\u0010\u0006\u001a\f\u0012\b\u0012\u00060\u0003j\u0002`\b0\u00072\b\b\u0002\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\u0003H\u00d6\u0001R\u001b\u0010\u0006\u001a\f\u0012\b\u0012\u00060\u0003j\u0002`\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014\u00a8\u0006#"}, d2={"Lcom/urbanairship/android/layout/ThomasModelFactory$LayoutNode;", "", "tag", "", "info", "Lcom/urbanairship/android/layout/info/ItemInfo;", "childTags", "", "Lcom/urbanairship/android/layout/Tag;", "controllers", "Lcom/urbanairship/android/layout/ThomasModelFactory$Controllers;", "pagerPageId", "(Ljava/lang/String;Lcom/urbanairship/android/layout/info/ItemInfo;Ljava/util/List;Lcom/urbanairship/android/layout/ThomasModelFactory$Controllers;Ljava/lang/String;)V", "getChildTags", "()Ljava/util/List;", "getControllers", "()Lcom/urbanairship/android/layout/ThomasModelFactory$Controllers;", "getInfo", "()Lcom/urbanairship/android/layout/info/ItemInfo;", "getPagerPageId", "()Ljava/lang/String;", "getTag", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "toString", "Builder", "urbanairship-layout_release"})
    public static final class LayoutNode {
        @NotNull
        private final String tag;
        @NotNull
        private final ItemInfo info;
        @NotNull
        private final List<String> childTags;
        @NotNull
        private final Controllers controllers;
        @Nullable
        private final String pagerPageId;

        public LayoutNode(@NotNull String tag, @NotNull ItemInfo info, @NotNull List<String> childTags, @NotNull Controllers controllers, @Nullable String pagerPageId) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            Intrinsics.checkNotNullParameter(childTags, (String)"childTags");
            Intrinsics.checkNotNullParameter((Object)controllers, (String)"controllers");
            this.tag = tag;
            this.info = info;
            this.childTags = childTags;
            this.controllers = controllers;
            this.pagerPageId = pagerPageId;
        }

        @NotNull
        public final String getTag() {
            return this.tag;
        }

        @NotNull
        public final ItemInfo getInfo() {
            return this.info;
        }

        @NotNull
        public final List<String> getChildTags() {
            return this.childTags;
        }

        @NotNull
        public final Controllers getControllers() {
            return this.controllers;
        }

        @Nullable
        public final String getPagerPageId() {
            return this.pagerPageId;
        }

        @NotNull
        public final String component1() {
            return this.tag;
        }

        @NotNull
        public final ItemInfo component2() {
            return this.info;
        }

        @NotNull
        public final List<String> component3() {
            return this.childTags;
        }

        @NotNull
        public final Controllers component4() {
            return this.controllers;
        }

        @Nullable
        public final String component5() {
            return this.pagerPageId;
        }

        @NotNull
        public final LayoutNode copy(@NotNull String tag, @NotNull ItemInfo info, @NotNull List<String> childTags, @NotNull Controllers controllers, @Nullable String pagerPageId) {
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            Intrinsics.checkNotNullParameter(childTags, (String)"childTags");
            Intrinsics.checkNotNullParameter((Object)controllers, (String)"controllers");
            return new LayoutNode(tag, info, childTags, controllers, pagerPageId);
        }

        public static /* synthetic */ LayoutNode copy$default(LayoutNode layoutNode, String string, ItemInfo itemInfo, List list, Controllers controllers, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = layoutNode.tag;
            }
            if ((n & 2) != 0) {
                itemInfo = layoutNode.info;
            }
            if ((n & 4) != 0) {
                list = layoutNode.childTags;
            }
            if ((n & 8) != 0) {
                controllers = layoutNode.controllers;
            }
            if ((n & 0x10) != 0) {
                string2 = layoutNode.pagerPageId;
            }
            return layoutNode.copy(string, itemInfo, list, controllers, string2);
        }

        @NotNull
        public String toString() {
            return "LayoutNode(tag=" + this.tag + ", info=" + this.info + ", childTags=" + this.childTags + ", controllers=" + this.controllers + ", pagerPageId=" + this.pagerPageId + ')';
        }

        public int hashCode() {
            int result = this.tag.hashCode();
            result = result * 31 + this.info.hashCode();
            result = result * 31 + ((Object)this.childTags).hashCode();
            result = result * 31 + this.controllers.hashCode();
            result = result * 31 + (this.pagerPageId == null ? 0 : this.pagerPageId.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LayoutNode)) {
                return false;
            }
            LayoutNode layoutNode = (LayoutNode)other;
            if (!Intrinsics.areEqual((Object)this.tag, (Object)layoutNode.tag)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.info, (Object)layoutNode.info)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.childTags, layoutNode.childTags)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.controllers, (Object)layoutNode.controllers)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.pagerPageId, (Object)layoutNode.pagerPageId);
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\b\u0002\u0010\u0006\u001a\f\u0012\b\u0012\u00060\u0003j\u0002`\b0\u0007\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\rJ\u0006\u0010\u001e\u001a\u00020\u001fJ\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0005H\u00c6\u0003J\u0013\u0010\"\u001a\f\u0012\b\u0012\u00060\u0003j\u0002`\b0\u0007H\u00c6\u0003J\u000b\u0010#\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010$\u001a\u00020\u000bH\u00c6\u0003J\u000b\u0010%\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003JS\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u0012\b\u0002\u0010\u0006\u001a\f\u0012\b\u0012\u00060\u0003j\u0002`\b0\u00072\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010*\u001a\u00020+H\u00d6\u0001J\t\u0010,\u001a\u00020\u0003H\u00d6\u0001R\u001b\u0010\u0006\u001a\f\u0012\b\u0012\u00060\u0003j\u0002`\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0013\u0010\f\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001c\u0010\t\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0019\"\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0019\u00a8\u0006-"}, d2={"Lcom/urbanairship/android/layout/ThomasModelFactory$LayoutNode$Builder;", "", "tag", "", "info", "Lcom/urbanairship/android/layout/info/ItemInfo;", "childTags", "", "Lcom/urbanairship/android/layout/Tag;", "style", "controllers", "Lcom/urbanairship/android/layout/ThomasModelFactory$Controllers$Builder;", "pagerPageId", "(Ljava/lang/String;Lcom/urbanairship/android/layout/info/ItemInfo;Ljava/util/List;Ljava/lang/String;Lcom/urbanairship/android/layout/ThomasModelFactory$Controllers$Builder;Ljava/lang/String;)V", "getChildTags", "()Ljava/util/List;", "getControllers", "()Lcom/urbanairship/android/layout/ThomasModelFactory$Controllers$Builder;", "setControllers", "(Lcom/urbanairship/android/layout/ThomasModelFactory$Controllers$Builder;)V", "getInfo", "()Lcom/urbanairship/android/layout/info/ItemInfo;", "setInfo", "(Lcom/urbanairship/android/layout/info/ItemInfo;)V", "getPagerPageId", "()Ljava/lang/String;", "getStyle", "setStyle", "(Ljava/lang/String;)V", "getTag", "build", "Lcom/urbanairship/android/layout/ThomasModelFactory$LayoutNode;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "toString", "urbanairship-layout_release"})
        public static final class Builder {
            @NotNull
            private final String tag;
            @NotNull
            private ItemInfo info;
            @NotNull
            private final List<String> childTags;
            @Nullable
            private String style;
            @NotNull
            private Controllers.Builder controllers;
            @Nullable
            private final String pagerPageId;

            public Builder(@NotNull String tag, @NotNull ItemInfo info, @NotNull List<String> childTags, @Nullable String style, @NotNull Controllers.Builder controllers, @Nullable String pagerPageId) {
                Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                Intrinsics.checkNotNullParameter(childTags, (String)"childTags");
                Intrinsics.checkNotNullParameter((Object)controllers, (String)"controllers");
                this.tag = tag;
                this.info = info;
                this.childTags = childTags;
                this.style = style;
                this.controllers = controllers;
                this.pagerPageId = pagerPageId;
            }

            public /* synthetic */ Builder(String string, ItemInfo itemInfo, List list, String string2, Controllers.Builder builder, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 4) != 0) {
                    list = new ArrayList();
                }
                if ((n & 8) != 0) {
                    string2 = null;
                }
                if ((n & 0x10) != 0) {
                    builder = new Controllers.Builder(null, null, null, null, null, null, 63, null);
                }
                this(string, itemInfo, list, string2, builder, string3);
            }

            @NotNull
            public final String getTag() {
                return this.tag;
            }

            @NotNull
            public final ItemInfo getInfo() {
                return this.info;
            }

            public final void setInfo(@NotNull ItemInfo itemInfo) {
                Intrinsics.checkNotNullParameter((Object)itemInfo, (String)"<set-?>");
                this.info = itemInfo;
            }

            @NotNull
            public final List<String> getChildTags() {
                return this.childTags;
            }

            @Nullable
            public final String getStyle() {
                return this.style;
            }

            public final void setStyle(@Nullable String string) {
                this.style = string;
            }

            @NotNull
            public final Controllers.Builder getControllers() {
                return this.controllers;
            }

            public final void setControllers(@NotNull Controllers.Builder builder) {
                Intrinsics.checkNotNullParameter((Object)builder, (String)"<set-?>");
                this.controllers = builder;
            }

            @Nullable
            public final String getPagerPageId() {
                return this.pagerPageId;
            }

            @NotNull
            public final LayoutNode build() {
                return new LayoutNode(this.tag, this.info, CollectionsKt.toList((Iterable)this.childTags), this.controllers.build(), this.pagerPageId);
            }

            @NotNull
            public final String component1() {
                return this.tag;
            }

            @NotNull
            public final ItemInfo component2() {
                return this.info;
            }

            @NotNull
            public final List<String> component3() {
                return this.childTags;
            }

            @Nullable
            public final String component4() {
                return this.style;
            }

            @NotNull
            public final Controllers.Builder component5() {
                return this.controllers;
            }

            @Nullable
            public final String component6() {
                return this.pagerPageId;
            }

            @NotNull
            public final Builder copy(@NotNull String tag, @NotNull ItemInfo info, @NotNull List<String> childTags, @Nullable String style, @NotNull Controllers.Builder controllers, @Nullable String pagerPageId) {
                Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                Intrinsics.checkNotNullParameter(childTags, (String)"childTags");
                Intrinsics.checkNotNullParameter((Object)controllers, (String)"controllers");
                return new Builder(tag, info, childTags, style, controllers, pagerPageId);
            }

            public static /* synthetic */ Builder copy$default(Builder builder, String string, ItemInfo itemInfo, List list, String string2, Controllers.Builder builder2, String string3, int n, Object object) {
                if ((n & 1) != 0) {
                    string = builder.tag;
                }
                if ((n & 2) != 0) {
                    itemInfo = builder.info;
                }
                if ((n & 4) != 0) {
                    list = builder.childTags;
                }
                if ((n & 8) != 0) {
                    string2 = builder.style;
                }
                if ((n & 0x10) != 0) {
                    builder2 = builder.controllers;
                }
                if ((n & 0x20) != 0) {
                    string3 = builder.pagerPageId;
                }
                return builder.copy(string, itemInfo, list, string2, builder2, string3);
            }

            @NotNull
            public String toString() {
                return "Builder(tag=" + this.tag + ", info=" + this.info + ", childTags=" + this.childTags + ", style=" + this.style + ", controllers=" + this.controllers + ", pagerPageId=" + this.pagerPageId + ')';
            }

            public int hashCode() {
                int result = this.tag.hashCode();
                result = result * 31 + this.info.hashCode();
                result = result * 31 + ((Object)this.childTags).hashCode();
                result = result * 31 + (this.style == null ? 0 : this.style.hashCode());
                result = result * 31 + this.controllers.hashCode();
                result = result * 31 + (this.pagerPageId == null ? 0 : this.pagerPageId.hashCode());
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Builder)) {
                    return false;
                }
                Builder builder = (Builder)other;
                if (!Intrinsics.areEqual((Object)this.tag, (Object)builder.tag)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.info, (Object)builder.info)) {
                    return false;
                }
                if (!Intrinsics.areEqual(this.childTags, builder.childTags)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.style, (Object)builder.style)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.controllers, (Object)builder.controllers)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.pagerPageId, (Object)builder.pagerPageId);
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0001'Bg\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u00060\u0004j\u0002`\u00050\u0003\u0012\u000e\u0010\u0006\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u0005\u0012\u000e\u0010\u0007\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u0005\u0012\u000e\u0010\b\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u0005\u0012\u000e\u0010\t\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u0005\u0012\u000e\u0010\n\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u0005\u00a2\u0006\u0002\u0010\u000bJ&\u0010\u0014\u001a\u00020\u00152\u001e\u0010\u0016\u001a\u001a\u0012\b\u0012\u00060\u0004j\u0002`\u0005\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00180\u0017J\u0013\u0010\u001a\u001a\f\u0012\b\u0012\u00060\u0004j\u0002`\u00050\u0003H\u00c6\u0003J\u0011\u0010\u001b\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u0005H\u00c6\u0003J\u0011\u0010\u001c\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u0005H\u00c6\u0003J\u0011\u0010\u001d\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u0005H\u00c6\u0003J\u0011\u0010\u001e\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u0005H\u00c6\u0003J\u0011\u0010\u001f\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u0005H\u00c6\u0003Jw\u0010 \u001a\u00020\u00002\u0012\b\u0002\u0010\u0002\u001a\f\u0012\b\u0012\u00060\u0004j\u0002`\u00050\u00032\u0010\b\u0002\u0010\u0006\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u00052\u0010\b\u0002\u0010\u0007\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u00052\u0010\b\u0002\u0010\b\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u00052\u0010\b\u0002\u0010\t\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u00052\u0010\b\u0002\u0010\n\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u0005H\u00c6\u0001J\u0013\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010$\u001a\u00020%H\u00d6\u0001J\t\u0010&\u001a\u00020\u0004H\u00d6\u0001R\u0019\u0010\u0007\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001b\u0010\u0002\u001a\f\u0012\b\u0012\u00060\u0004j\u0002`\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0019\u0010\t\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0019\u0010\u0006\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u0019\u0010\b\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\rR\u0019\u0010\n\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\r\u00a8\u0006("}, d2={"Lcom/urbanairship/android/layout/ThomasModelFactory$Controllers;", "", "form", "", "", "Lcom/urbanairship/android/layout/Tag;", "pager", "checkbox", "radio", "layout", "story", "(Ljava/util/List;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getCheckbox", "()Ljava/lang/String;", "getForm", "()Ljava/util/List;", "getLayout", "getPager", "getRadio", "getStory", "buildLayoutState", "Lcom/urbanairship/android/layout/environment/LayoutState;", "states", "", "Lcom/urbanairship/android/layout/environment/SharedState;", "Lcom/urbanairship/android/layout/environment/State;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "toString", "Builder", "urbanairship-layout_release"})
    public static final class Controllers {
        @NotNull
        private final List<String> form;
        @Nullable
        private final String pager;
        @Nullable
        private final String checkbox;
        @Nullable
        private final String radio;
        @Nullable
        private final String layout;
        @Nullable
        private final String story;

        public Controllers(@NotNull List<String> form, @Nullable String pager, @Nullable String checkbox, @Nullable String radio, @Nullable String layout, @Nullable String story) {
            Intrinsics.checkNotNullParameter(form, (String)"form");
            this.form = form;
            this.pager = pager;
            this.checkbox = checkbox;
            this.radio = radio;
            this.layout = layout;
            this.story = story;
        }

        @NotNull
        public final List<String> getForm() {
            return this.form;
        }

        @Nullable
        public final String getPager() {
            return this.pager;
        }

        @Nullable
        public final String getCheckbox() {
            return this.checkbox;
        }

        @Nullable
        public final String getRadio() {
            return this.radio;
        }

        @Nullable
        public final String getLayout() {
            return this.layout;
        }

        @Nullable
        public final String getStory() {
            return this.story;
        }

        @NotNull
        public final LayoutState buildLayoutState(@NotNull Map<String, SharedState<State>> states) {
            SharedState<State> sharedState;
            SharedState<State> sharedState2;
            SharedState<State> sharedState3;
            SharedState<State> sharedState4;
            SharedState<State> sharedState5;
            SharedState<State> sharedState6;
            SharedState<State> sharedState7;
            Intrinsics.checkNotNullParameter(states, (String)"states");
            String childForm = (String)CollectionsKt.firstOrNull(this.form);
            String parentForm = (String)CollectionsKt.getOrNull(this.form, (int)1);
            String string = childForm;
            if (string != null) {
                String it = string;
                boolean bl = false;
                SharedState<State> sharedState8 = states.get(it);
                sharedState7 = sharedState8 instanceof SharedState ? sharedState8 : null;
            } else {
                sharedState7 = null;
            }
            SharedState<State> sharedState9 = sharedState7;
            String string2 = parentForm;
            if (string2 != null) {
                String it = string2;
                boolean bl = false;
                sharedState6 = states.get(it);
                sharedState5 = sharedState6 instanceof SharedState ? sharedState6 : null;
            } else {
                sharedState5 = null;
            }
            SharedState<State> sharedState10 = sharedState5;
            String string3 = this.pager;
            if (string3 != null) {
                String it = string3;
                boolean bl = false;
                SharedState<State> sharedState11 = states.get(it);
                sharedState4 = sharedState11 instanceof SharedState ? sharedState11 : null;
            } else {
                sharedState4 = null;
            }
            SharedState<State> sharedState12 = sharedState4;
            String string4 = this.checkbox;
            if (string4 != null) {
                String it = string4;
                boolean bl = false;
                SharedState<State> sharedState13 = states.get(it);
                sharedState3 = sharedState13 instanceof SharedState ? sharedState13 : null;
            } else {
                sharedState3 = null;
            }
            SharedState<State> sharedState14 = sharedState3;
            String string5 = this.radio;
            if (string5 != null) {
                String it = string5;
                boolean bl = false;
                SharedState<State> sharedState15 = states.get(it);
                sharedState2 = sharedState15 instanceof SharedState ? sharedState15 : null;
            } else {
                sharedState2 = null;
            }
            SharedState<State> sharedState16 = sharedState2;
            String string6 = this.layout;
            if (string6 != null) {
                String it = string6;
                boolean bl = false;
                SharedState<State> sharedState17 = states.get(it);
                sharedState = sharedState17 instanceof SharedState ? sharedState17 : null;
            } else {
                sharedState = null;
            }
            sharedState6 = sharedState;
            return new LayoutState(sharedState12, sharedState9, sharedState10, sharedState14, sharedState16, sharedState6);
        }

        @NotNull
        public final List<String> component1() {
            return this.form;
        }

        @Nullable
        public final String component2() {
            return this.pager;
        }

        @Nullable
        public final String component3() {
            return this.checkbox;
        }

        @Nullable
        public final String component4() {
            return this.radio;
        }

        @Nullable
        public final String component5() {
            return this.layout;
        }

        @Nullable
        public final String component6() {
            return this.story;
        }

        @NotNull
        public final Controllers copy(@NotNull List<String> form, @Nullable String pager, @Nullable String checkbox, @Nullable String radio, @Nullable String layout, @Nullable String story) {
            Intrinsics.checkNotNullParameter(form, (String)"form");
            return new Controllers(form, pager, checkbox, radio, layout, story);
        }

        public static /* synthetic */ Controllers copy$default(Controllers controllers, List list, String string, String string2, String string3, String string4, String string5, int n, Object object) {
            if ((n & 1) != 0) {
                list = controllers.form;
            }
            if ((n & 2) != 0) {
                string = controllers.pager;
            }
            if ((n & 4) != 0) {
                string2 = controllers.checkbox;
            }
            if ((n & 8) != 0) {
                string3 = controllers.radio;
            }
            if ((n & 0x10) != 0) {
                string4 = controllers.layout;
            }
            if ((n & 0x20) != 0) {
                string5 = controllers.story;
            }
            return controllers.copy(list, string, string2, string3, string4, string5);
        }

        @NotNull
        public String toString() {
            return "Controllers(form=" + this.form + ", pager=" + this.pager + ", checkbox=" + this.checkbox + ", radio=" + this.radio + ", layout=" + this.layout + ", story=" + this.story + ')';
        }

        public int hashCode() {
            int result = ((Object)this.form).hashCode();
            result = result * 31 + (this.pager == null ? 0 : this.pager.hashCode());
            result = result * 31 + (this.checkbox == null ? 0 : this.checkbox.hashCode());
            result = result * 31 + (this.radio == null ? 0 : this.radio.hashCode());
            result = result * 31 + (this.layout == null ? 0 : this.layout.hashCode());
            result = result * 31 + (this.story == null ? 0 : this.story.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Controllers)) {
                return false;
            }
            Controllers controllers = (Controllers)other;
            if (!Intrinsics.areEqual(this.form, controllers.form)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.pager, (Object)controllers.pager)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.checkbox, (Object)controllers.checkbox)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.radio, (Object)controllers.radio)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.layout, (Object)controllers.layout)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.story, (Object)controllers.story);
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001Bs\u0012\u0012\b\u0002\u0010\u0002\u001a\f\u0012\b\u0012\u00060\u0004j\u0002`\u00050\u0003\u0012\u0010\b\u0002\u0010\u0006\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u0005\u0012\u0010\b\u0002\u0010\u0007\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u0005\u0012\u0010\b\u0002\u0010\b\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u0005\u0012\u0010\b\u0002\u0010\t\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u0005\u0012\u0010\b\u0002\u0010\n\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u0005\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u001a\u001a\u00020\u001bJ\u0013\u0010\u001c\u001a\f\u0012\b\u0012\u00060\u0004j\u0002`\u00050\u0003H\u00c6\u0003J\u0011\u0010\u001d\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u0005H\u00c6\u0003J\u0011\u0010\u001e\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u0005H\u00c6\u0003J\u0011\u0010\u001f\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u0005H\u00c6\u0003J\u0011\u0010 \u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u0005H\u00c6\u0003J\u0011\u0010!\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u0005H\u00c6\u0003Jw\u0010\"\u001a\u00020\u00002\u0012\b\u0002\u0010\u0002\u001a\f\u0012\b\u0012\u00060\u0004j\u0002`\u00050\u00032\u0010\b\u0002\u0010\u0006\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u00052\u0010\b\u0002\u0010\u0007\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u00052\u0010\b\u0002\u0010\b\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u00052\u0010\b\u0002\u0010\t\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u00052\u0010\b\u0002\u0010\n\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u0005H\u00c6\u0001J\u0013\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010&\u001a\u00020'H\u00d6\u0001J\t\u0010(\u001a\u00020\u0004H\u00d6\u0001J\u001a\u0010)\u001a\u00020\u00002\u0006\u0010*\u001a\u00020+2\n\u0010,\u001a\u00060\u0004j\u0002`\u0005R\"\u0010\u0007\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0002\u001a\f\u0012\b\u0012\u00060\u0004j\u0002`\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\"\u0010\t\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\r\"\u0004\b\u0013\u0010\u000fR\"\u0010\u0006\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\r\"\u0004\b\u0015\u0010\u000fR\"\u0010\b\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\r\"\u0004\b\u0017\u0010\u000fR\"\u0010\n\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\r\"\u0004\b\u0019\u0010\u000f\u00a8\u0006-"}, d2={"Lcom/urbanairship/android/layout/ThomasModelFactory$Controllers$Builder;", "", "form", "", "", "Lcom/urbanairship/android/layout/Tag;", "pager", "checkbox", "radio", "layout", "story", "(Ljava/util/List;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getCheckbox", "()Ljava/lang/String;", "setCheckbox", "(Ljava/lang/String;)V", "getForm", "()Ljava/util/List;", "getLayout", "setLayout", "getPager", "setPager", "getRadio", "setRadio", "getStory", "setStory", "build", "Lcom/urbanairship/android/layout/ThomasModelFactory$Controllers;", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "toString", "update", "type", "Lcom/urbanairship/android/layout/property/ViewType;", "tag", "urbanairship-layout_release"})
        public static final class Builder {
            @NotNull
            private final List<String> form;
            @Nullable
            private String pager;
            @Nullable
            private String checkbox;
            @Nullable
            private String radio;
            @Nullable
            private String layout;
            @Nullable
            private String story;

            public Builder(@NotNull List<String> form, @Nullable String pager, @Nullable String checkbox, @Nullable String radio, @Nullable String layout, @Nullable String story) {
                Intrinsics.checkNotNullParameter(form, (String)"form");
                this.form = form;
                this.pager = pager;
                this.checkbox = checkbox;
                this.radio = radio;
                this.layout = layout;
                this.story = story;
            }

            public /* synthetic */ Builder(List list, String string, String string2, String string3, String string4, String string5, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    list = new ArrayList();
                }
                if ((n & 2) != 0) {
                    string = null;
                }
                if ((n & 4) != 0) {
                    string2 = null;
                }
                if ((n & 8) != 0) {
                    string3 = null;
                }
                if ((n & 0x10) != 0) {
                    string4 = null;
                }
                if ((n & 0x20) != 0) {
                    string5 = null;
                }
                this(list, string, string2, string3, string4, string5);
            }

            @NotNull
            public final List<String> getForm() {
                return this.form;
            }

            @Nullable
            public final String getPager() {
                return this.pager;
            }

            public final void setPager(@Nullable String string) {
                this.pager = string;
            }

            @Nullable
            public final String getCheckbox() {
                return this.checkbox;
            }

            public final void setCheckbox(@Nullable String string) {
                this.checkbox = string;
            }

            @Nullable
            public final String getRadio() {
                return this.radio;
            }

            public final void setRadio(@Nullable String string) {
                this.radio = string;
            }

            @Nullable
            public final String getLayout() {
                return this.layout;
            }

            public final void setLayout(@Nullable String string) {
                this.layout = string;
            }

            @Nullable
            public final String getStory() {
                return this.story;
            }

            public final void setStory(@Nullable String string) {
                this.story = string;
            }

            @NotNull
            public final Builder update(@NotNull ViewType type, @NotNull String tag) {
                Builder builder;
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
                switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                    case 1: 
                    case 2: {
                        builder = Builder.copy$default(this, CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)tag), (Iterable)this.form), null, null, null, null, null, 62, null);
                        break;
                    }
                    case 3: {
                        builder = Builder.copy$default(this, null, tag, null, null, null, null, 61, null);
                        break;
                    }
                    case 4: {
                        builder = Builder.copy$default(this, null, null, tag, null, null, null, 59, null);
                        break;
                    }
                    case 5: {
                        builder = Builder.copy$default(this, null, null, null, tag, null, null, 55, null);
                        break;
                    }
                    case 6: {
                        builder = Builder.copy$default(this, null, null, null, null, tag, null, 47, null);
                        break;
                    }
                    case 7: {
                        builder = Builder.copy$default(this, null, null, null, null, null, tag, 31, null);
                        break;
                    }
                    default: {
                        builder = this;
                    }
                }
                return builder;
            }

            @NotNull
            public final Controllers build() {
                return new Controllers(CollectionsKt.toList((Iterable)this.form), this.pager, this.checkbox, this.radio, this.layout, this.story);
            }

            @NotNull
            public final List<String> component1() {
                return this.form;
            }

            @Nullable
            public final String component2() {
                return this.pager;
            }

            @Nullable
            public final String component3() {
                return this.checkbox;
            }

            @Nullable
            public final String component4() {
                return this.radio;
            }

            @Nullable
            public final String component5() {
                return this.layout;
            }

            @Nullable
            public final String component6() {
                return this.story;
            }

            @NotNull
            public final Builder copy(@NotNull List<String> form, @Nullable String pager, @Nullable String checkbox, @Nullable String radio, @Nullable String layout, @Nullable String story) {
                Intrinsics.checkNotNullParameter(form, (String)"form");
                return new Builder(form, pager, checkbox, radio, layout, story);
            }

            public static /* synthetic */ Builder copy$default(Builder builder, List list, String string, String string2, String string3, String string4, String string5, int n, Object object) {
                if ((n & 1) != 0) {
                    list = builder.form;
                }
                if ((n & 2) != 0) {
                    string = builder.pager;
                }
                if ((n & 4) != 0) {
                    string2 = builder.checkbox;
                }
                if ((n & 8) != 0) {
                    string3 = builder.radio;
                }
                if ((n & 0x10) != 0) {
                    string4 = builder.layout;
                }
                if ((n & 0x20) != 0) {
                    string5 = builder.story;
                }
                return builder.copy(list, string, string2, string3, string4, string5);
            }

            @NotNull
            public String toString() {
                return "Builder(form=" + this.form + ", pager=" + this.pager + ", checkbox=" + this.checkbox + ", radio=" + this.radio + ", layout=" + this.layout + ", story=" + this.story + ')';
            }

            public int hashCode() {
                int result = ((Object)this.form).hashCode();
                result = result * 31 + (this.pager == null ? 0 : this.pager.hashCode());
                result = result * 31 + (this.checkbox == null ? 0 : this.checkbox.hashCode());
                result = result * 31 + (this.radio == null ? 0 : this.radio.hashCode());
                result = result * 31 + (this.layout == null ? 0 : this.layout.hashCode());
                result = result * 31 + (this.story == null ? 0 : this.story.hashCode());
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Builder)) {
                    return false;
                }
                Builder builder = (Builder)other;
                if (!Intrinsics.areEqual(this.form, builder.form)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.pager, (Object)builder.pager)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.checkbox, (Object)builder.checkbox)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.radio, (Object)builder.radio)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.layout, (Object)builder.layout)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.story, (Object)builder.story);
            }

            public Builder() {
                this(null, null, null, null, null, null, 63, null);
            }

            @Metadata(mv={1, 7, 1}, k=3, xi=48)
            public final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[ViewType.values().length];
                    nArray[ViewType.FORM_CONTROLLER.ordinal()] = 1;
                    nArray[ViewType.NPS_FORM_CONTROLLER.ordinal()] = 2;
                    nArray[ViewType.PAGER_CONTROLLER.ordinal()] = 3;
                    nArray[ViewType.CHECKBOX_CONTROLLER.ordinal()] = 4;
                    nArray[ViewType.RADIO_INPUT_CONTROLLER.ordinal()] = 5;
                    nArray[ViewType.STATE_CONTROLLER.ordinal()] = 6;
                    nArray[ViewType.STORY_INDICATOR.ordinal()] = 7;
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        }
    }
}

