/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.environment;

import com.urbanairship.UALog;
import com.urbanairship.android.layout.reporting.AttributeName;
import com.urbanairship.channel.AttributeEditor;
import com.urbanairship.json.JsonValue;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u0007\u001a\u00020\b2\u0016\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\b\u0012\u00060\fj\u0002`\r0\nJ \u0010\u000e\u001a\u00020\b*\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u00060\fj\u0002`\rH\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/urbanairship/android/layout/environment/AttributeHandler;", "", "contactEditorFactory", "Lkotlin/Function0;", "Lcom/urbanairship/channel/AttributeEditor;", "channelEditorFactory", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "update", "", "attributes", "", "Lcom/urbanairship/android/layout/reporting/AttributeName;", "Lcom/urbanairship/json/JsonValue;", "Lcom/urbanairship/android/layout/property/AttributeValue;", "setAttributeValue", "attribute", "", "value", "urbanairship-layout_release"})
public final class AttributeHandler {
    @NotNull
    private final Function0<AttributeEditor> contactEditorFactory;
    @NotNull
    private final Function0<AttributeEditor> channelEditorFactory;

    public AttributeHandler(@NotNull Function0<? extends AttributeEditor> contactEditorFactory, @NotNull Function0<? extends AttributeEditor> channelEditorFactory) {
        Intrinsics.checkNotNullParameter(contactEditorFactory, (String)"contactEditorFactory");
        Intrinsics.checkNotNullParameter(channelEditorFactory, (String)"channelEditorFactory");
        this.contactEditorFactory = contactEditorFactory;
        this.channelEditorFactory = channelEditorFactory;
    }

    public /* synthetic */ AttributeHandler(Function0 function0, Function0 function02, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            function0 = 1.INSTANCE;
        }
        if ((n & 2) != 0) {
            function02 = 2.INSTANCE;
        }
        this((Function0<? extends AttributeEditor>)function0, (Function0<? extends AttributeEditor>)function02);
    }

    public final void update(@NotNull Map<AttributeName, ? extends JsonValue> attributes) {
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        AttributeEditor contactEditor = (AttributeEditor)this.contactEditorFactory.invoke();
        AttributeEditor channelEditor = (AttributeEditor)this.channelEditorFactory.invoke();
        for (Map.Entry<AttributeName, ? extends JsonValue> entry : attributes.entrySet()) {
            String attribute;
            AttributeName key = entry.getKey();
            JsonValue value = entry.getValue();
            if ((key.isContact() ? key.getContact() : key.getChannel()) == null) continue;
            attribute = attribute;
            if (value.isNull()) continue;
            UALog.v((String)("Setting " + (key.isChannel() ? "channel" : "contact") + " attribute: '" + attribute + "' => '" + value + '\''), (Object[])new Object[0]);
            AttributeEditor editor = key.isContact() ? contactEditor : channelEditor;
            this.setAttributeValue(editor, attribute, value);
        }
        contactEditor.apply();
        channelEditor.apply();
    }

    private final void setAttributeValue(AttributeEditor $this$setAttributeValue, String attribute, JsonValue value) {
        if (value.isString()) {
            $this$setAttributeValue.setAttribute(attribute, value.optString());
        } else if (value.isDouble()) {
            $this$setAttributeValue.setAttribute(attribute, value.getDouble(-1.0));
        } else if (value.isFloat()) {
            $this$setAttributeValue.setAttribute(attribute, value.getFloat(-1.0f));
        } else if (value.isInteger()) {
            $this$setAttributeValue.setAttribute(attribute, value.getInt(-1));
        } else if (value.isLong()) {
            $this$setAttributeValue.setAttribute(attribute, value.getLong(-1L));
        }
    }

    public AttributeHandler() {
        this(null, null, 3, null);
    }
}

