/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.environment;

import android.app.Activity;
import android.webkit.WebChromeClient;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.urbanairship.Predicate;
import com.urbanairship.android.layout.environment.ViewEnvironment;
import com.urbanairship.android.layout.util.Factory;
import com.urbanairship.android.layout.util.ImageCache;
import com.urbanairship.app.ActivityMonitor;
import com.urbanairship.webkit.AirshipWebChromeClient;
import com.urbanairship.webkit.AirshipWebViewClient;

public class DefaultViewEnvironment
implements ViewEnvironment {
    @NonNull
    private final Activity activity;
    @NonNull
    private final ActivityMonitor activityMonitor;
    @NonNull
    private final Factory<WebChromeClient> webChromeClientFactory;
    @NonNull
    private final Factory<AirshipWebViewClient> webViewClientFactory;
    @NonNull
    private final ImageCache imageCache;
    private final boolean isIgnoringSafeAreas;

    public DefaultViewEnvironment(@NonNull Activity activity, @NonNull ActivityMonitor activityMonitor, @Nullable Factory<AirshipWebViewClient> webViewClientFactory, @Nullable ImageCache imageCache, boolean isIgnoringSafeAreas) {
        this.activity = activity;
        this.activityMonitor = activityMonitor;
        this.webChromeClientFactory = () -> new AirshipWebChromeClient(activity);
        this.webViewClientFactory = webViewClientFactory != null ? webViewClientFactory : AirshipWebViewClient::new;
        this.imageCache = imageCache != null ? imageCache : url -> null;
        this.isIgnoringSafeAreas = isIgnoringSafeAreas;
    }

    @Override
    @NonNull
    public ActivityMonitor activityMonitor() {
        return this.activityMonitor;
    }

    @Override
    @NonNull
    public Predicate<Activity> hostingActivityPredicate() {
        return activityToCheck -> activityToCheck == this.activity;
    }

    @Override
    @NonNull
    public Factory<WebChromeClient> webChromeClientFactory() {
        return this.webChromeClientFactory;
    }

    @Override
    @NonNull
    public Factory<AirshipWebViewClient> webViewClientFactory() {
        return this.webViewClientFactory;
    }

    @Override
    @NonNull
    public ImageCache imageCache() {
        return this.imageCache;
    }

    @Override
    public boolean isIgnoringSafeAreas() {
        return this.isIgnoringSafeAreas;
    }
}

