/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.event;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.urbanairship.android.layout.reporting.AttributeName;
import com.urbanairship.android.layout.reporting.FormData;
import com.urbanairship.android.layout.reporting.FormInfo;
import com.urbanairship.android.layout.reporting.PagerData;
import com.urbanairship.json.JsonValue;
import java.util.Map;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public abstract class ReportingEvent {
    @NonNull
    private final ReportType reportType;

    protected ReportingEvent(@NonNull ReportType reportType) {
        this.reportType = reportType;
    }

    private static abstract class PagerReportingEvent
    extends ReportingEvent {
        @NonNull
        private final PagerData pagerData;

        public PagerReportingEvent(@NonNull ReportType type, @NonNull PagerData pagerData) {
            super(type);
            this.pagerData = pagerData;
        }

        @NonNull
        public PagerData getPagerData() {
            return this.pagerData;
        }
    }

    private static abstract class DismissReportingEvent
    extends ReportingEvent {
        private final long displayTime;

        public DismissReportingEvent(@NonNull ReportType type, long displayTime) {
            super(type);
            this.displayTime = displayTime;
        }

        public long getDisplayTime() {
            return this.displayTime;
        }
    }

    public static class PageAction
    extends PagerReportingEvent {
        @NonNull
        private final String actionId;
        @Nullable
        private final JsonValue reportingMetadata;

        public PageAction(@NonNull String actionId, @Nullable JsonValue reportingMetadata, @NonNull PagerData pagerData) {
            super(ReportType.PAGE_ACTION, pagerData);
            this.actionId = actionId;
            this.reportingMetadata = reportingMetadata;
        }

        @NonNull
        public String getActionId() {
            return this.actionId;
        }

        @Nullable
        public JsonValue getReportingMetadata() {
            return this.reportingMetadata;
        }

        public String toString() {
            return "PageAction{actionId='" + this.actionId + '\'' + ", reportingMetadata=" + this.reportingMetadata + '}';
        }
    }

    public static class PageGesture
    extends PagerReportingEvent {
        @NonNull
        private final String gestureId;
        @Nullable
        private final JsonValue reportingMetadata;

        public PageGesture(@NonNull String gestureId, @Nullable JsonValue reportingMetadata, @NonNull PagerData pagerData) {
            super(ReportType.PAGE_GESTURE, pagerData);
            this.gestureId = gestureId;
            this.reportingMetadata = reportingMetadata;
        }

        @NonNull
        public String getGestureId() {
            return this.gestureId;
        }

        @Nullable
        public JsonValue getReportingMetadata() {
            return this.reportingMetadata;
        }

        public String toString() {
            return "PageGesture{gestureId='" + this.gestureId + '\'' + ", reportingMetadata=" + this.reportingMetadata + '}';
        }
    }

    public static class FormDisplay
    extends ReportingEvent {
        @NonNull
        private final FormInfo formInfo;

        public FormDisplay(@NonNull FormInfo formInfo) {
            super(ReportType.FORM_DISPLAY);
            this.formInfo = formInfo;
        }

        @NonNull
        public FormInfo getFormInfo() {
            return this.formInfo;
        }

        @NonNull
        public String toString() {
            return "ReportingEvent.FormDisplay{formInfo='" + this.formInfo + '\'' + '}';
        }
    }

    public static class FormResult
    extends ReportingEvent {
        @NonNull
        private final FormData.BaseForm formData;
        @NonNull
        private final FormInfo formInfo;
        @NonNull
        private final Map<AttributeName, JsonValue> attributes;

        public FormResult(@NonNull FormData.BaseForm formData, @NonNull FormInfo formInfo, @NonNull Map<AttributeName, JsonValue> attributes) {
            super(ReportType.FORM_RESULT);
            this.formData = formData;
            this.formInfo = formInfo;
            this.attributes = attributes;
        }

        @NonNull
        public FormData.BaseForm getFormData() {
            return this.formData;
        }

        @NonNull
        public FormInfo getFormInfo() {
            return this.formInfo;
        }

        public String toString() {
            return "FormResult{formData=" + this.formData + ", formInfo=" + this.formInfo + ", attributes=" + this.attributes + '}';
        }

        @NonNull
        public Map<AttributeName, JsonValue> getAttributes() {
            return this.attributes;
        }
    }

    public static class DismissFromButton
    extends DismissReportingEvent {
        @NonNull
        private final String buttonId;
        @Nullable
        private final String buttonDescription;
        private final boolean cancel;

        public DismissFromButton(@NonNull String buttonId, @Nullable String buttonDescription, boolean cancel, long displayTime) {
            super(ReportType.BUTTON_DISMISS, displayTime);
            this.buttonId = buttonId;
            this.buttonDescription = buttonDescription;
            this.cancel = cancel;
        }

        @NonNull
        public String getButtonId() {
            return this.buttonId;
        }

        @Nullable
        public String getButtonDescription() {
            return this.buttonDescription;
        }

        public boolean isCancel() {
            return this.cancel;
        }

        @NonNull
        public String toString() {
            return "ReportingEvent.DismissFromButton{buttonId='" + this.buttonId + '\'' + ", buttonDescription='" + this.buttonDescription + '\'' + ", cancel=" + this.cancel + ", displayTime=" + this.getDisplayTime() + '}';
        }
    }

    public static class DismissFromOutside
    extends DismissReportingEvent {
        public DismissFromOutside(long displayTime) {
            super(ReportType.OUTSIDE_DISMISS, displayTime);
        }

        @NonNull
        public String toString() {
            return "ReportingEvent.DismissFromOutside{displayTime=" + this.getDisplayTime() + '}';
        }
    }

    public static class ButtonTap
    extends ReportingEvent {
        @NonNull
        private final String buttonId;
        @Nullable
        private final JsonValue reportingMetadata;

        public ButtonTap(@NonNull String buttonId, @Nullable JsonValue reportingMetadata) {
            super(ReportType.BUTTON_TAP);
            this.buttonId = buttonId;
            this.reportingMetadata = reportingMetadata;
        }

        @NonNull
        public String getButtonId() {
            return this.buttonId;
        }

        @Nullable
        public JsonValue getReportingMetadata() {
            return this.reportingMetadata;
        }

        @NonNull
        public String toString() {
            return "ReportingEvent.ButtonTap{buttonId='" + this.buttonId + '\'' + '}';
        }
    }

    public static class PageSwipe
    extends PagerReportingEvent {
        private final int fromPageIndex;
        private final int toPageIndex;
        private final String fromPageId;
        private final String toPageId;

        public PageSwipe(@NonNull PagerData pagerData, int fromPageIndex, @NonNull String fromPageId, int toPageIndex, @NonNull String toPageId) {
            super(ReportType.PAGE_SWIPE, pagerData);
            this.fromPageIndex = fromPageIndex;
            this.fromPageId = fromPageId;
            this.toPageIndex = toPageIndex;
            this.toPageId = toPageId;
        }

        public int getFromPageIndex() {
            return this.fromPageIndex;
        }

        @NonNull
        public String getFromPageId() {
            return this.fromPageId;
        }

        public int getToPageIndex() {
            return this.toPageIndex;
        }

        @NonNull
        public String getToPageId() {
            return this.toPageId;
        }

        public String toString() {
            return "PageSwipe{fromPageIndex=" + this.fromPageIndex + ", toPageIndex=" + this.toPageIndex + ", fromPageId='" + this.fromPageId + '\'' + ", toPageId='" + this.toPageId + '\'' + '}';
        }
    }

    public static class PageView
    extends PagerReportingEvent {
        private final long displayedAt;

        public PageView(@NonNull PagerData pagerData, long displayedAt) {
            super(ReportType.PAGE_VIEW, pagerData);
            this.displayedAt = displayedAt;
        }

        public long getDisplayedAt() {
            return this.displayedAt;
        }

        @NonNull
        public String toString() {
            return "ReportingEvent.PageView{pagerData=" + this.getPagerData() + ", displayedAt=" + this.getDisplayedAt() + '}';
        }
    }

    public static enum ReportType {
        PAGE_VIEW,
        PAGE_SWIPE,
        PAGE_GESTURE,
        PAGE_ACTION,
        BUTTON_TAP,
        OUTSIDE_DISMISS,
        BUTTON_DISMISS,
        FORM_RESULT,
        FORM_DISPLAY;

    }
}

