/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.gestures;

import android.graphics.RectF;
import android.view.MotionEvent;
import com.urbanairship.UALog;
import com.urbanairship.android.layout.gestures.BottomRegion;
import com.urbanairship.android.layout.gestures.LeftRegion;
import com.urbanairship.android.layout.gestures.RightRegion;
import com.urbanairship.android.layout.gestures.TopRegion;
import com.urbanairship.android.layout.property.GestureDirection;
import com.urbanairship.android.layout.property.GestureLocation;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 %2\u00020\u0001:\u0001%B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J(\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J(\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u001d\u001a\u00020\u0012J\u001e\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020 \u0018\u00010\u001f2\u0006\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u0012J\u0016\u0010#\u001a\u00020$2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/urbanairship/android/layout/gestures/PagerGestureMapper;", "", "rect", "Landroid/graphics/RectF;", "isRtl", "", "(Landroid/graphics/RectF;Z)V", "bottomRegion", "Lcom/urbanairship/android/layout/gestures/BottomRegion;", "leftRegion", "Lcom/urbanairship/android/layout/gestures/LeftRegion;", "rightRegion", "Lcom/urbanairship/android/layout/gestures/RightRegion;", "topRegion", "Lcom/urbanairship/android/layout/gestures/TopRegion;", "getSwipeAngle", "", "x1", "", "y1", "x2", "y2", "getSwipeDistance", "mapSwipe", "Lcom/urbanairship/android/layout/property/GestureDirection;", "e1", "Landroid/view/MotionEvent;", "e2", "velocityX", "velocityY", "mapTap", "", "Lcom/urbanairship/android/layout/property/GestureLocation;", "x", "y", "onLayoutChanged", "", "Companion", "urbanairship-layout_release"})
public final class PagerGestureMapper {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private RectF rect;
    private boolean isRtl;
    @NotNull
    private TopRegion topRegion;
    @NotNull
    private BottomRegion bottomRegion;
    @NotNull
    private LeftRegion leftRegion;
    @NotNull
    private RightRegion rightRegion;
    @Deprecated
    private static final int SWIPE_MIN_DISTANCE = 120;
    @Deprecated
    private static final int SWIPE_MIN_VELOCITY = 200;
    @Deprecated
    private static final double UP_ANGLE = 90.0;
    @Deprecated
    private static final double DOWN_ANGLE = 270.0;
    @Deprecated
    private static final double ANGLE_SLOP = 15.0;
    @Deprecated
    @NotNull
    private static final ClosedFloatingPointRange<Double> UP_RANGE = RangesKt.rangeTo((double)75.0, (double)105.0);
    @Deprecated
    @NotNull
    private static final ClosedFloatingPointRange<Double> DOWN_RANGE = RangesKt.rangeTo((double)255.0, (double)285.0);

    public PagerGestureMapper(@NotNull RectF rect, boolean isRtl) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        this.rect = rect;
        this.isRtl = isRtl;
        this.topRegion = new TopRegion(this.rect);
        this.bottomRegion = new BottomRegion(this.rect);
        this.leftRegion = new LeftRegion(this.rect);
        this.rightRegion = new RightRegion(this.rect);
    }

    public final void onLayoutChanged(@NotNull RectF rect, boolean isRtl) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        if (Intrinsics.areEqual((Object)this.rect, (Object)rect) && isRtl == this.isRtl) {
            return;
        }
        this.rect = rect;
        this.isRtl = isRtl;
        this.topRegion = new TopRegion(rect);
        this.bottomRegion = new BottomRegion(rect);
        this.leftRegion = new LeftRegion(rect);
        this.rightRegion = new RightRegion(rect);
    }

    @Nullable
    public final List<GestureLocation> mapTap(float x, float y) {
        List list;
        if (this.topRegion.contains((int)x, (int)y)) {
            list = CollectionsKt.listOf((Object)((Object)GestureLocation.TOP));
        } else if (this.bottomRegion.contains((int)x, (int)y)) {
            list = CollectionsKt.listOf((Object)((Object)GestureLocation.BOTTOM));
        } else if (this.leftRegion.contains((int)x, (int)y)) {
            GestureLocation[] gestureLocationArray = new GestureLocation[]{GestureLocation.LEFT, this.isRtl ? GestureLocation.END : GestureLocation.START};
            list = CollectionsKt.listOf((Object[])gestureLocationArray);
        } else if (this.rightRegion.contains((int)x, (int)y)) {
            GestureLocation[] gestureLocationArray = new GestureLocation[]{GestureLocation.RIGHT, this.isRtl ? GestureLocation.START : GestureLocation.END};
            list = CollectionsKt.listOf((Object[])gestureLocationArray);
        } else {
            list = null;
        }
        return list;
    }

    @Nullable
    public final GestureDirection mapSwipe(@NotNull MotionEvent e1, @NotNull MotionEvent e2, float velocityX, float velocityY) {
        float y2;
        Pair pair;
        float x2;
        float y1;
        Intrinsics.checkNotNullParameter((Object)e1, (String)"e1");
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e2");
        UALog.w((String)("PagerGestureMapper - mapSwipe: " + e1 + ", " + e2 + ", " + velocityX + ", " + velocityY), (Object[])new Object[0]);
        if (e1.getPointerCount() > 1 || e2.getPointerCount() > 1) {
            return null;
        }
        Pair pair2 = TuplesKt.to((Object)Float.valueOf(e1.getX()), (Object)Float.valueOf(e1.getY()));
        float x1 = ((Number)pair2.component1()).floatValue();
        if (this.getSwipeDistance(x1, y1 = ((Number)pair2.component2()).floatValue(), x2 = ((Number)(pair = TuplesKt.to((Object)Float.valueOf(e2.getX()), (Object)Float.valueOf(e2.getY()))).component1()).floatValue(), y2 = ((Number)pair.component2()).floatValue()) < 120.0) {
            return null;
        }
        double d = this.getSwipeAngle(x1, y1, x2, y2);
        return UP_RANGE.contains((Comparable)Double.valueOf(d)) ? GestureDirection.UP : (DOWN_RANGE.contains((Comparable)Double.valueOf(d)) ? GestureDirection.DOWN : null);
    }

    private final double getSwipeAngle(float x1, float y1, float x2, float y2) {
        double rad = (double)((float)Math.atan2(y1 - y2, x2 - x1)) + Math.PI;
        return (rad * (double)180 / Math.PI + (double)180) % (double)360;
    }

    private final double getSwipeDistance(float x1, float y1, float x2, float y2) {
        float dx = x2 - x1;
        float dy = y2 - y1;
        return Math.sqrt((float)Math.pow(dx, 2) + (float)Math.pow(dy, 2));
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/urbanairship/android/layout/gestures/PagerGestureMapper$Companion;", "", "()V", "ANGLE_SLOP", "", "DOWN_ANGLE", "DOWN_RANGE", "Lkotlin/ranges/ClosedFloatingPointRange;", "SWIPE_MIN_DISTANCE", "", "SWIPE_MIN_VELOCITY", "UP_ANGLE", "UP_RANGE", "urbanairship-layout_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

