/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.model;

import android.content.Context;
import android.view.View;
import androidx.annotation.VisibleForTesting;
import com.urbanairship.UALog;
import com.urbanairship.android.layout.environment.LayoutEvent;
import com.urbanairship.android.layout.environment.LayoutState;
import com.urbanairship.android.layout.environment.ModelEnvironment;
import com.urbanairship.android.layout.environment.SharedState;
import com.urbanairship.android.layout.environment.State;
import com.urbanairship.android.layout.environment.ViewEnvironment;
import com.urbanairship.android.layout.event.ReportingEvent;
import com.urbanairship.android.layout.info.VisibilityInfo;
import com.urbanairship.android.layout.model.BaseModel;
import com.urbanairship.android.layout.model.ModelProperties;
import com.urbanairship.android.layout.property.Border;
import com.urbanairship.android.layout.property.Color;
import com.urbanairship.android.layout.property.EnableBehaviorType;
import com.urbanairship.android.layout.property.EnableBehaviorTypeKt;
import com.urbanairship.android.layout.property.EventHandler;
import com.urbanairship.android.layout.property.EventHandlerKt;
import com.urbanairship.android.layout.property.StateAction;
import com.urbanairship.android.layout.property.ViewType;
import com.urbanairship.android.layout.reporting.AttributeName;
import com.urbanairship.android.layout.reporting.LayoutData;
import com.urbanairship.android.layout.util.ViewExtensionsKt;
import com.urbanairship.android.layout.widget.CheckableView;
import com.urbanairship.android.layout.widget.TappableView;
import com.urbanairship.json.JsonExtensionsKt;
import com.urbanairship.json.JsonSerializable;
import com.urbanairship.json.JsonValue;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.SupervisorKt;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00ee\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\u00020\u0005:\u0001rBe\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u0012\u0010\b\u0002\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f\u0012\u0010\b\u0002\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u000f\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@H\u0004J\u0010\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020DH\u0002J\u001b\u0010E\u001a\u00028\u00002\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020I\u00a2\u0006\u0002\u0010JJ\u0010\u0010K\u001a\u00020L2\u0006\u0010C\u001a\u00020MH\u0002J\u0010\u0010N\u001a\u00020L2\u0006\u0010C\u001a\u00020OH\u0002J\u001a\u0010P\u001a\u00020L2\u0006\u0010Q\u001a\u00020R2\n\b\u0002\u0010S\u001a\u0004\u0018\u00010\u0005J\u001d\u0010T\u001a\u00028\u00002\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020IH$\u00a2\u0006\u0002\u0010JJC\u0010U\u001a\u00020L21\u0010V\u001a-\b\u0001\u0012\u0013\u0012\u00110B\u00a2\u0006\f\bX\u0012\b\bY\u0012\u0004\b\b(Z\u0012\n\u0012\b\u0012\u0004\u0012\u00020L0[\u0012\u0006\u0012\u0004\u0018\u00010\u00050WH\u0004\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\\J\u0017\u0010]\u001a\u00020L2\u0006\u0010^\u001a\u00028\u0000H\u0011\u00a2\u0006\u0004\b_\u0010`J\u0015\u0010a\u001a\u00020L2\u0006\u0010^\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010`J\u0017\u0010b\u001a\u00020L2\u0006\u0010^\u001a\u00028\u0000H\u0011\u00a2\u0006\u0004\bc\u0010`J\u0018\u0010d\u001a\u00020L2\u0006\u0010?\u001a\u00020e2\u0006\u0010C\u001a\u00020fH\u0004J*\u0010g\u001a\u00020L2\u0016\u0010h\u001a\u0012\u0012\u0004\u0012\u00020j\u0012\u0004\u0012\u00020k0ij\u0002`l2\b\b\u0002\u0010C\u001a\u00020fH\u0004J\u0015\u0010m\u001a\u00020L2\u0006\u0010^\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010`J \u0010n\u001a\u00020L2\u0016\u0010o\u001a\u0012\u0012\u0004\u0012\u00020p\u0012\b\u0012\u00060kj\u0002`q0iH\u0004R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0019\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0013\u001a\u00020\u0014X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0019\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001dR\u0014\u0010!\u001a\u00020\"X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u001e\u0010%\u001a\u0004\u0018\u00018\u0001X\u0090\u000e\u00a2\u0006\u0010\n\u0002\u0010*\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u0014\u0010+\u001a\u00020,X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0014\u0010\u0015\u001a\u00020\u0016X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0011\u00101\u001a\u000202\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u000e\u00105\u001a\u000206X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00107\u001a\u00020,X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010.R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u0013\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006s"}, d2={"Lcom/urbanairship/android/layout/model/BaseModel;", "T", "Landroid/view/View;", "L", "Lcom/urbanairship/android/layout/model/BaseModel$Listener;", "", "viewType", "Lcom/urbanairship/android/layout/property/ViewType;", "backgroundColor", "Lcom/urbanairship/android/layout/property/Color;", "border", "Lcom/urbanairship/android/layout/property/Border;", "visibility", "Lcom/urbanairship/android/layout/info/VisibilityInfo;", "eventHandlers", "", "Lcom/urbanairship/android/layout/property/EventHandler;", "enableBehaviors", "Lcom/urbanairship/android/layout/property/EnableBehaviorType;", "environment", "Lcom/urbanairship/android/layout/environment/ModelEnvironment;", "properties", "Lcom/urbanairship/android/layout/model/ModelProperties;", "(Lcom/urbanairship/android/layout/property/ViewType;Lcom/urbanairship/android/layout/property/Color;Lcom/urbanairship/android/layout/property/Border;Lcom/urbanairship/android/layout/info/VisibilityInfo;Ljava/util/List;Ljava/util/List;Lcom/urbanairship/android/layout/environment/ModelEnvironment;Lcom/urbanairship/android/layout/model/ModelProperties;)V", "getBackgroundColor", "()Lcom/urbanairship/android/layout/property/Color;", "getBorder", "()Lcom/urbanairship/android/layout/property/Border;", "getEnableBehaviors", "()Ljava/util/List;", "getEnvironment", "()Lcom/urbanairship/android/layout/environment/ModelEnvironment;", "getEventHandlers", "layoutState", "Lcom/urbanairship/android/layout/environment/LayoutState;", "getLayoutState", "()Lcom/urbanairship/android/layout/environment/LayoutState;", "listener", "getListener$urbanairship_layout_release", "()Lcom/urbanairship/android/layout/model/BaseModel$Listener;", "setListener$urbanairship_layout_release", "(Lcom/urbanairship/android/layout/model/BaseModel$Listener;)V", "Lcom/urbanairship/android/layout/model/BaseModel$Listener;", "modelScope", "Lkotlinx/coroutines/CoroutineScope;", "getModelScope", "()Lkotlinx/coroutines/CoroutineScope;", "getProperties", "()Lcom/urbanairship/android/layout/model/ModelProperties;", "viewId", "", "getViewId", "()I", "viewJob", "Lkotlinx/coroutines/CompletableJob;", "viewScope", "getViewScope", "getViewType", "()Lcom/urbanairship/android/layout/property/ViewType;", "getVisibility", "()Lcom/urbanairship/android/layout/info/VisibilityInfo;", "broadcast", "Lkotlinx/coroutines/Job;", "event", "Lcom/urbanairship/android/layout/environment/LayoutEvent;", "checkVisibility", "", "state", "Lcom/urbanairship/android/layout/environment/State$Layout;", "createView", "context", "Landroid/content/Context;", "viewEnvironment", "Lcom/urbanairship/android/layout/environment/ViewEnvironment;", "(Landroid/content/Context;Lcom/urbanairship/android/layout/environment/ViewEnvironment;)Landroid/view/View;", "handleFormBehaviors", "", "Lcom/urbanairship/android/layout/environment/State$Form;", "handlePagerBehaviors", "Lcom/urbanairship/android/layout/environment/State$Pager;", "handleViewEvent", "type", "Lcom/urbanairship/android/layout/property/EventHandler$Type;", "value", "onCreateView", "onFormInputDisplayed", "block", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "isDisplayed", "Lkotlin/coroutines/Continuation;", "(Lkotlin/jvm/functions/Function2;)V", "onViewAttached", "view", "onViewAttached$urbanairship_layout_release", "(Landroid/view/View;)V", "onViewCreated", "onViewDetached", "onViewDetached$urbanairship_layout_release", "report", "Lcom/urbanairship/android/layout/event/ReportingEvent;", "Lcom/urbanairship/android/layout/reporting/LayoutData;", "runActions", "actions", "", "", "Lcom/urbanairship/json/JsonValue;", "Lcom/urbanairship/android/layout/property/Actions;", "setupViewListeners", "updateAttributes", "attributes", "Lcom/urbanairship/android/layout/reporting/AttributeName;", "Lcom/urbanairship/android/layout/property/AttributeValue;", "Listener", "urbanairship-layout_release"})
public abstract class BaseModel<T extends View, L extends Listener> {
    @NotNull
    private final ViewType viewType;
    @Nullable
    private final Color backgroundColor;
    @Nullable
    private final Border border;
    @Nullable
    private final VisibilityInfo visibility;
    @Nullable
    private final List<EventHandler> eventHandlers;
    @Nullable
    private final List<EnableBehaviorType> enableBehaviors;
    @NotNull
    private final ModelEnvironment environment;
    @NotNull
    private final ModelProperties properties;
    @Nullable
    private L listener;
    private final int viewId;
    @NotNull
    private final CoroutineScope modelScope;
    @NotNull
    private final CompletableJob viewJob;
    @NotNull
    private final CoroutineScope viewScope;
    @NotNull
    private final LayoutState layoutState;

    public BaseModel(@NotNull ViewType viewType, @Nullable Color backgroundColor, @Nullable Border border, @Nullable VisibilityInfo visibility, @Nullable List<EventHandler> eventHandlers, @Nullable List<? extends EnableBehaviorType> enableBehaviors, @NotNull ModelEnvironment environment, @NotNull ModelProperties properties) {
        Intrinsics.checkNotNullParameter((Object)((Object)viewType), (String)"viewType");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        this.viewType = viewType;
        this.backgroundColor = backgroundColor;
        this.border = border;
        this.visibility = visibility;
        this.eventHandlers = eventHandlers;
        this.enableBehaviors = enableBehaviors;
        this.environment = environment;
        this.properties = properties;
        this.viewId = View.generateViewId();
        this.modelScope = this.environment.getModelScope();
        this.viewJob = SupervisorKt.SupervisorJob$default(null, (int)1, null);
        this.viewScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)Dispatchers.getMain().getImmediate().plus((CoroutineContext)this.viewJob));
        this.layoutState = this.environment.getLayoutState();
    }

    public /* synthetic */ BaseModel(ViewType viewType, Color color, Border border, VisibilityInfo visibilityInfo, List list, List list2, ModelEnvironment modelEnvironment, ModelProperties modelProperties, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            color = null;
        }
        if ((n & 4) != 0) {
            border = null;
        }
        if ((n & 8) != 0) {
            visibilityInfo = null;
        }
        if ((n & 0x10) != 0) {
            list = null;
        }
        if ((n & 0x20) != 0) {
            list2 = null;
        }
        this(viewType, color, border, visibilityInfo, list, list2, modelEnvironment, modelProperties);
    }

    @NotNull
    public final ViewType getViewType() {
        return this.viewType;
    }

    @Nullable
    public final Color getBackgroundColor() {
        return this.backgroundColor;
    }

    @Nullable
    public final Border getBorder() {
        return this.border;
    }

    @Nullable
    public final VisibilityInfo getVisibility() {
        return this.visibility;
    }

    @Nullable
    public final List<EventHandler> getEventHandlers() {
        return this.eventHandlers;
    }

    @Nullable
    public final List<EnableBehaviorType> getEnableBehaviors() {
        return this.enableBehaviors;
    }

    @NotNull
    protected final ModelEnvironment getEnvironment() {
        return this.environment;
    }

    @NotNull
    protected final ModelProperties getProperties() {
        return this.properties;
    }

    @Nullable
    public L getListener$urbanairship_layout_release() {
        return this.listener;
    }

    public void setListener$urbanairship_layout_release(@Nullable L l) {
        this.listener = l;
    }

    public final int getViewId() {
        return this.viewId;
    }

    @NotNull
    public final T createView(@NotNull Context context, @NotNull ViewEnvironment viewEnvironment) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)viewEnvironment, (String)"viewEnvironment");
        T view = this.onCreateView(context, viewEnvironment);
        this.onViewCreated(view);
        view.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(this, view){
            final /* synthetic */ BaseModel<T, L> this$0;
            final /* synthetic */ T $view;
            {
                this.this$0 = $receiver;
                this.$view = $view;
            }

            public void onViewAttachedToWindow(@NotNull View v) {
                Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                BaseModel.access$setupViewListeners(this.this$0, this.$view);
                this.this$0.onViewAttached$urbanairship_layout_release(this.$view);
            }

            public void onViewDetachedFromWindow(@NotNull View v) {
                Intrinsics.checkNotNullParameter((Object)v, (String)"v");
                this.this$0.onViewDetached$urbanairship_layout_release(this.$view);
                JobKt.cancelChildren$default((Job)((Job)BaseModel.access$getViewJob$p(this.this$0)), null, (int)1, null);
            }
        });
        if (this.enableBehaviors != null) {
            if (EnableBehaviorTypeKt.getHasPagerBehaviors(this.enableBehaviors)) {
                if (this.layoutState.getPager() == null) {
                    boolean $i$a$-checkNotNull-BaseModel$createView$32 = false;
                    String $i$a$-checkNotNull-BaseModel$createView$32 = "Pager state is required for pager behaviors";
                    throw new IllegalStateException($i$a$-checkNotNull-BaseModel$createView$32.toString());
                }
                BuildersKt.launch$default((CoroutineScope)this.modelScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    int label;
                    final /* synthetic */ BaseModel<T, L> this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = this.this$0.getLayoutState().getPager().getChanges().collect(new FlowCollector(this.this$0){
                                    final /* synthetic */ BaseModel<T, L> this$0;
                                    {
                                        this.this$0 = $receiver;
                                    }

                                    @Nullable
                                    public final Object emit(@NotNull State.Pager it, @NotNull Continuation<? super Unit> $completion) {
                                        BaseModel.access$handlePagerBehaviors(this.this$0, it);
                                        return Unit.INSTANCE;
                                    }
                                }, (Continuation)this);
                                if (object3 != object2) throw new KotlinNothingValueException();
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                throw new KotlinNothingValueException();
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
            if (EnableBehaviorTypeKt.getHasFormBehaviors(this.enableBehaviors)) {
                if (this.layoutState.getForm() == null) {
                    boolean bl = false;
                    String string = "Form state is required for form behaviors";
                    throw new IllegalStateException(string.toString());
                }
                BuildersKt.launch$default((CoroutineScope)this.modelScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    int label;
                    final /* synthetic */ BaseModel<T, L> this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = this.this$0.getLayoutState().getForm().getChanges().collect(new FlowCollector(this.this$0){
                                    final /* synthetic */ BaseModel<T, L> this$0;
                                    {
                                        this.this$0 = $receiver;
                                    }

                                    @Nullable
                                    public final Object emit(@NotNull State.Form it, @NotNull Continuation<? super Unit> $completion) {
                                        BaseModel.access$handleFormBehaviors(this.this$0, it);
                                        return Unit.INSTANCE;
                                    }
                                }, (Continuation)this);
                                if (object3 != object2) throw new KotlinNothingValueException();
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                throw new KotlinNothingValueException();
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }
        }
        return view;
    }

    protected final void onFormInputDisplayed(@NotNull Function2<? super Boolean, ? super Continuation<? super Unit>, ? extends Object> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        if (!this.viewType.isFormInput()) {
            return;
        }
        BuildersKt.launch$default((CoroutineScope)this.modelScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, block, null){
            int label;
            final /* synthetic */ BaseModel<T, L> this$0;
            final /* synthetic */ Function2<Boolean, Continuation<? super Unit>, Object> $block;
            {
                this.this$0 = $receiver;
                this.$block = $block;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                void $result;
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Ref.BooleanRef isDisplayed = new Ref.BooleanRef();
                        SharedState<State.Pager> sharedState = this.this$0.getLayoutState().getPager();
                        if (sharedState == null || (sharedState = sharedState.getChanges()) == null) break;
                        this.label = 1;
                        Object object3 = sharedState.collect(new FlowCollector(isDisplayed, this.this$0, this.$block){
                            final /* synthetic */ Ref.BooleanRef $isDisplayed;
                            final /* synthetic */ BaseModel<T, L> this$0;
                            final /* synthetic */ Function2<Boolean, Continuation<? super Unit>, Object> $block;
                            {
                                this.$isDisplayed = $isDisplayed;
                                this.this$0 = $receiver;
                                this.$block = $block;
                            }

                            @Nullable
                            public final Object emit(@NotNull State.Pager state, @NotNull Continuation<? super Unit> $completion) {
                                String currentPageId = state.getPageIds().get(state.getPageIndex());
                                boolean wasDisplayed = this.$isDisplayed.element;
                                this.$isDisplayed.element = Intrinsics.areEqual((Object)currentPageId, (Object)this.this$0.getProperties().getPagerPageId());
                                if (wasDisplayed != this.$isDisplayed.element) {
                                    Object object = this.$block.invoke((Object)Boxing.boxBoolean((boolean)this.$isDisplayed.element), $completion);
                                    if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                        return object;
                                    }
                                    return Unit.INSTANCE;
                                }
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) throw new KotlinNothingValueException();
                        return object2;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        throw new KotlinNothingValueException();
                    }
                }
                this.label = 2;
                Object object4 = this.$block.invoke((Object)Boxing.boxBoolean((boolean)true), (Object)((Object)this));
                if (object4 != object2) return Unit.INSTANCE;
                return object2;
                {
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        object4 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void setupViewListeners(T view) {
        if (EventHandlerKt.hasTapHandler(this.eventHandlers) && !(view instanceof TappableView) && !(view instanceof CheckableView)) {
            BuildersKt.launch$default((CoroutineScope)this.viewScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(view, this, null){
                int label;
                final /* synthetic */ T $view;
                final /* synthetic */ BaseModel<T, L> this$0;
                {
                    this.$view = $view;
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = ViewExtensionsKt.debouncedClicks$default(this.$view, 0L, 1, null).collect(new FlowCollector(this.this$0){
                                final /* synthetic */ BaseModel<T, L> this$0;
                                {
                                    this.this$0 = $receiver;
                                }

                                @Nullable
                                public final Object emit(@NotNull Unit it, @NotNull Continuation<? super Unit> $completion) {
                                    BaseModel.handleViewEvent$default(this.this$0, EventHandler.Type.TAP, null, 2, null);
                                    return Unit.INSTANCE;
                                }
                            }, (Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
        if (this.visibility != null) {
            BuildersKt.launch$default((CoroutineScope)this.viewScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ BaseModel<T, L> this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            SharedState<State.Layout> sharedState = this.this$0.getLayoutState().getLayout();
                            if (sharedState == null || (sharedState = sharedState.getChanges()) == null) return Unit.INSTANCE;
                            this.label = 1;
                            Object object3 = sharedState.collect(new FlowCollector(this.this$0){
                                final /* synthetic */ BaseModel<T, L> this$0;
                                {
                                    this.this$0 = $receiver;
                                }

                                @Nullable
                                public final Object emit(@NotNull State.Layout it, @NotNull Continuation<? super Unit> $completion) {
                                    block0: {
                                        boolean isVisible = BaseModel.access$checkVisibility(this.this$0, it);
                                        L l = this.this$0.getListener$urbanairship_layout_release();
                                        if (l == null) break block0;
                                        l.setVisibility(isVisible);
                                    }
                                    return Unit.INSTANCE;
                                }
                            }, (Continuation)this);
                            if (object3 != object2) throw new KotlinNothingValueException();
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            throw new KotlinNothingValueException();
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    @NotNull
    protected abstract T onCreateView(@NotNull Context var1, @NotNull ViewEnvironment var2);

    protected void onViewCreated(@NotNull T view) {
        Intrinsics.checkNotNullParameter(view, (String)"view");
    }

    @VisibleForTesting(otherwise=4)
    public void onViewAttached$urbanairship_layout_release(@NotNull T view) {
        Intrinsics.checkNotNullParameter(view, (String)"view");
    }

    @VisibleForTesting(otherwise=4)
    public void onViewDetached$urbanairship_layout_release(@NotNull T view) {
        Intrinsics.checkNotNullParameter(view, (String)"view");
    }

    @NotNull
    protected final CoroutineScope getModelScope() {
        return this.modelScope;
    }

    @NotNull
    protected final CoroutineScope getViewScope() {
        return this.viewScope;
    }

    @NotNull
    protected final LayoutState getLayoutState() {
        return this.layoutState;
    }

    protected final void report(@NotNull ReportingEvent event, @NotNull LayoutData state) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.environment.getReporter().report(event, state);
    }

    protected final void runActions(@NotNull Map<String, ? extends JsonValue> actions, @NotNull LayoutData state) {
        Intrinsics.checkNotNullParameter(actions, (String)"actions");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.environment.getActionsRunner().run(actions, state);
    }

    public static /* synthetic */ void runActions$default(BaseModel baseModel, Map map2, LayoutData layoutData, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: runActions");
        }
        if ((n & 2) != 0) {
            layoutData = LayoutState.reportingContext$default(baseModel.layoutState, null, null, null, 7, null);
        }
        baseModel.runActions(map2, layoutData);
    }

    @NotNull
    protected final Job broadcast(@NotNull LayoutEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return BuildersKt.launch$default((CoroutineScope)this.modelScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, event, null){
            int label;
            final /* synthetic */ BaseModel<T, L> this$0;
            final /* synthetic */ LayoutEvent $event;
            {
                this.this$0 = $receiver;
                this.$event = $event;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.getEnvironment().getEventHandler().broadcast(this.$event, (Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    protected final void updateAttributes(@NotNull Map<AttributeName, ? extends JsonValue> attributes) {
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        this.environment.getAttributeHandler().update(attributes);
    }

    private final boolean checkVisibility(State.Layout state) {
        VisibilityInfo visibilityInfo = this.visibility;
        if (visibilityInfo == null || (visibilityInfo = visibilityInfo.getInvertWhenStateMatcher()) == null) {
            return true;
        }
        VisibilityInfo matcher = visibilityInfo;
        boolean match = matcher.apply((JsonSerializable)JsonExtensionsKt.toJsonMap(state.getState()));
        return match ? this.visibility.getDefault() : !this.visibility.getDefault();
    }

    private final void handleFormBehaviors(State.Form state) {
        block1: {
            List<EnableBehaviorType> list = this.enableBehaviors;
            if (list == null) {
                return;
            }
            List<EnableBehaviorType> behaviors = list;
            boolean hasFormValidationBehavior = behaviors.contains((Object)EnableBehaviorType.FORM_VALIDATION);
            boolean hasFormSubmitBehavior = behaviors.contains((Object)EnableBehaviorType.FORM_SUBMISSION);
            boolean isValid = !hasFormValidationBehavior || state.isValid();
            boolean isEnabled = hasFormSubmitBehavior && hasFormValidationBehavior ? !state.isSubmitted() && isValid : (hasFormSubmitBehavior ? !state.isSubmitted() : (hasFormValidationBehavior ? isValid : true));
            L l = this.getListener$urbanairship_layout_release();
            if (l == null) break block1;
            l.setEnabled(isEnabled);
        }
    }

    private final void handlePagerBehaviors(State.Pager state) {
        block1: {
            List<EnableBehaviorType> list = this.enableBehaviors;
            if (list == null) {
                return;
            }
            List<EnableBehaviorType> behaviors = list;
            boolean hasPagerNextBehavior = behaviors.contains((Object)EnableBehaviorType.PAGER_NEXT);
            boolean hasPagerPrevBehavior = behaviors.contains((Object)EnableBehaviorType.PAGER_PREVIOUS);
            boolean isEnabled = hasPagerNextBehavior && state.getHasNext() || hasPagerPrevBehavior && state.getHasPrevious();
            L l = this.getListener$urbanairship_layout_release();
            if (l == null) break block1;
            l.setEnabled(isEnabled);
        }
    }

    public final void handleViewEvent(@NotNull EventHandler.Type type, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        List list = this.eventHandlers;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        for (EventHandler handler : list) {
            if (handler.getType() != type) continue;
            for (StateAction action : handler.getActions()) {
                Unit unit;
                SharedState<State.Layout> state;
                StateAction stateAction = action;
                if (stateAction instanceof StateAction.SetFormValue) {
                    Unit unit2;
                    if (this.layoutState.getLayout() != null) {
                        boolean bl = false;
                        UALog.v((String)("StateAction: SetFormValue " + ((StateAction.SetFormValue)action).getKey() + " = " + JsonValue.wrapOpt((Object)value)), (Object[])new Object[0]);
                        state.update((Function1<State.Layout, State.Layout>)((Function1)new Function1<State.Layout, State.Layout>(action, value){
                            final /* synthetic */ StateAction $action;
                            final /* synthetic */ Object $value;
                            {
                                this.$action = $action;
                                this.$value = $value;
                                super(1);
                            }

                            @NotNull
                            public final State.Layout invoke(@NotNull State.Layout it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                return it.copy(MapsKt.plus(it.getState(), (Pair)TuplesKt.to((Object)((StateAction.SetFormValue)this.$action).getKey(), (Object)JsonValue.wrapOpt((Object)this.$value))));
                            }
                        }));
                        unit2 = Unit.INSTANCE;
                    } else {
                        unit2 = null;
                    }
                    if (unit2 != null) continue;
                    UALog.w((String)"StateAction: SetFormValue skipped. Missing State Controller!", (Object[])new Object[0]);
                    continue;
                }
                if (stateAction instanceof StateAction.SetState) {
                    Unit unit3;
                    if (this.layoutState.getLayout() != null) {
                        boolean bl = false;
                        UALog.v((String)("StateAction: SetState " + ((StateAction.SetState)action).getKey() + " = " + ((StateAction.SetState)action).getValue()), (Object[])new Object[0]);
                        state.update((Function1<State.Layout, State.Layout>)((Function1)new Function1<State.Layout, State.Layout>(action){
                            final /* synthetic */ StateAction $action;
                            {
                                this.$action = $action;
                                super(1);
                            }

                            @NotNull
                            public final State.Layout invoke(@NotNull State.Layout it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                return it.copy(MapsKt.plus(it.getState(), (Pair)TuplesKt.to((Object)((StateAction.SetState)this.$action).getKey(), (Object)((StateAction.SetState)this.$action).getValue())));
                            }
                        }));
                        unit3 = Unit.INSTANCE;
                    } else {
                        unit3 = null;
                    }
                    if (unit3 != null) continue;
                    UALog.w((String)"StateAction: SetState skipped. Missing State Controller!", (Object[])new Object[0]);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)stateAction, (Object)StateAction.ClearState.INSTANCE)) continue;
                if (this.layoutState.getLayout() != null) {
                    boolean bl = false;
                    UALog.v((String)"StateAction: ClearState", (Object[])new Object[0]);
                    state.update((Function1<State.Layout, State.Layout>)((Function1)handleViewEvent.3.1.INSTANCE));
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                if (unit != null) continue;
                UALog.w((String)"StateAction: ClearState skipped. Missing State Controller!", (Object[])new Object[0]);
            }
        }
    }

    public static /* synthetic */ void handleViewEvent$default(BaseModel baseModel, EventHandler.Type type, Object object, int n, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: handleViewEvent");
        }
        if ((n & 2) != 0) {
            object = null;
        }
        baseModel.handleViewEvent(type, object);
    }

    public static final /* synthetic */ void access$setupViewListeners(BaseModel $this, View view) {
        $this.setupViewListeners(view);
    }

    public static final /* synthetic */ CompletableJob access$getViewJob$p(BaseModel $this) {
        return $this.viewJob;
    }

    public static final /* synthetic */ void access$handlePagerBehaviors(BaseModel $this, State.Pager state) {
        $this.handlePagerBehaviors(state);
    }

    public static final /* synthetic */ void access$handleFormBehaviors(BaseModel $this, State.Form state) {
        $this.handleFormBehaviors(state);
    }

    public static final /* synthetic */ boolean access$checkVisibility(BaseModel $this, State.Layout state) {
        return $this.checkVisibility(state);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b`\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0005H&\u00a8\u0006\b"}, d2={"Lcom/urbanairship/android/layout/model/BaseModel$Listener;", "", "setEnabled", "", "enabled", "", "setVisibility", "visible", "urbanairship-layout_release"})
    public static interface Listener {
        public void setVisibility(boolean var1);

        public void setEnabled(boolean var1);
    }
}

