/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.property;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.urbanairship.android.layout.property.BannerPlacement;
import com.urbanairship.android.layout.property.Orientation;
import com.urbanairship.android.layout.property.WindowSize;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonList;
import com.urbanairship.json.JsonMap;
import java.util.ArrayList;
import java.util.List;

public class BannerPlacementSelector {
    @NonNull
    private final BannerPlacement placement;
    @Nullable
    private final WindowSize windowSize;
    @Nullable
    private final Orientation orientation;

    public BannerPlacementSelector(@NonNull BannerPlacement placement, @Nullable WindowSize windowSize, @Nullable Orientation orientation) {
        this.placement = placement;
        this.windowSize = windowSize;
        this.orientation = orientation;
    }

    @NonNull
    public static BannerPlacementSelector fromJson(@NonNull JsonMap json) throws JsonException {
        JsonMap placementJson = json.opt("placement").optMap();
        String windowSizeString = json.opt("window_size").optString();
        String orientationString = json.opt("orientation").optString();
        BannerPlacement placement = BannerPlacement.fromJson(placementJson);
        WindowSize windowSize = windowSizeString.isEmpty() ? null : WindowSize.from(windowSizeString);
        Orientation orientation = orientationString.isEmpty() ? null : Orientation.from(orientationString);
        return new BannerPlacementSelector(placement, windowSize, orientation);
    }

    @NonNull
    public static List<BannerPlacementSelector> fromJsonList(@NonNull JsonList json) throws JsonException {
        ArrayList<BannerPlacementSelector> selectors = new ArrayList<BannerPlacementSelector>(json.size());
        for (int i = 0; i < json.size(); ++i) {
            JsonMap selectorJson = json.get(i).optMap();
            BannerPlacementSelector selector = BannerPlacementSelector.fromJson(selectorJson);
            selectors.add(selector);
        }
        return selectors;
    }

    @NonNull
    public BannerPlacement getPlacement() {
        return this.placement;
    }

    @Nullable
    public WindowSize getWindowSize() {
        return this.windowSize;
    }

    @Nullable
    public Orientation getOrientation() {
        return this.orientation;
    }
}

