/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.property;

import android.widget.ImageView;
import androidx.annotation.NonNull;
import com.urbanairship.json.JsonException;
import java.util.Locale;

public enum MediaFit {
    CENTER("center", ImageView.ScaleType.CENTER),
    CENTER_INSIDE("center_inside", ImageView.ScaleType.FIT_CENTER),
    CENTER_CROP("center_crop", ImageView.ScaleType.CENTER_CROP),
    FIT_CROP("fit_crop", ImageView.ScaleType.MATRIX);

    @NonNull
    private final String value;
    @NonNull
    private final ImageView.ScaleType scaleType;

    private MediaFit(String value, ImageView.ScaleType scaleType) {
        this.value = value;
        this.scaleType = scaleType;
    }

    @NonNull
    public static MediaFit from(@NonNull String value) throws JsonException {
        for (MediaFit type : MediaFit.values()) {
            if (!type.value.equals(value.toLowerCase(Locale.ROOT))) continue;
            return type;
        }
        throw new JsonException("Unknown MediaFit value: " + value);
    }

    @NonNull
    public ImageView.ScaleType getScaleType() {
        return this.scaleType;
    }

    @NonNull
    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }
}

