/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.property;

import androidx.annotation.NonNull;
import com.urbanairship.json.JsonException;
import java.util.Locale;

public enum MediaType {
    IMAGE("image"),
    VIDEO("video"),
    YOUTUBE("youtube");

    @NonNull
    private final String value;

    private MediaType(String value) {
        this.value = value;
    }

    @NonNull
    public static MediaType from(@NonNull String value) throws JsonException {
        for (MediaType type : MediaType.values()) {
            if (!type.value.equals(value.toLowerCase(Locale.ROOT))) continue;
            return type;
        }
        throw new JsonException("Unknown MediaType value: " + value);
    }

    @NonNull
    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }
}

