/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.property;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.urbanairship.android.layout.model.SafeAreaAware;
import com.urbanairship.android.layout.property.Border;
import com.urbanairship.android.layout.property.Color;
import com.urbanairship.android.layout.property.ConstrainedSize;
import com.urbanairship.android.layout.property.Margin;
import com.urbanairship.android.layout.property.Orientation;
import com.urbanairship.android.layout.property.Position;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonMap;

public class ModalPlacement
implements SafeAreaAware {
    @NonNull
    private final ConstrainedSize size;
    @Nullable
    private final Margin margin;
    @Nullable
    private final Position position;
    @Nullable
    private final Color shadeColor;
    private final boolean ignoreSafeArea;
    @Nullable
    private final Orientation orientationLock;
    @Nullable
    private final Border border;
    @Nullable
    private final Color backgroundColor;

    public ModalPlacement(@NonNull ConstrainedSize size, @Nullable Margin margin, @Nullable Position position, @Nullable Color shadeColor, boolean ignoreSafeArea, @Nullable Orientation orientationLock, @Nullable Border border, @Nullable Color backgroundColor) {
        this.size = size;
        this.margin = margin;
        this.position = position;
        this.shadeColor = shadeColor;
        this.ignoreSafeArea = ignoreSafeArea;
        this.orientationLock = orientationLock;
        this.border = border;
        this.backgroundColor = backgroundColor;
    }

    @NonNull
    public static ModalPlacement fromJson(@NonNull JsonMap json) throws JsonException {
        JsonMap sizeJson = json.opt("size").optMap();
        if (sizeJson.isEmpty()) {
            throw new JsonException("Failed to parse Modal Placement! Field 'size' is required.");
        }
        JsonMap positionJson = json.opt("position").optMap();
        JsonMap marginJson = json.opt("margin").optMap();
        JsonMap borderJson = json.opt("border").optMap();
        JsonMap backgroundJson = json.opt("background_color").optMap();
        ConstrainedSize size = ConstrainedSize.fromJson(sizeJson);
        Margin margin = marginJson.isEmpty() ? null : Margin.fromJson(marginJson);
        Position position = positionJson.isEmpty() ? null : Position.fromJson(positionJson);
        Color shadeColor = Color.fromJsonField(json, "shade_color");
        boolean ignoreSafeArea = SafeAreaAware.ignoreSafeAreaFromJson(json);
        String orientationString = json.opt("device").optMap().opt("lock_orientation").optString();
        Orientation orientationLock = orientationString.isEmpty() ? null : Orientation.from(orientationString);
        Border border = borderJson.isEmpty() ? null : Border.fromJson(borderJson);
        Color backgroundColor = backgroundJson.isEmpty() ? null : Color.fromJson(backgroundJson);
        return new ModalPlacement(size, margin, position, shadeColor, ignoreSafeArea, orientationLock, border, backgroundColor);
    }

    @Nullable
    public Orientation getOrientationLock() {
        return this.orientationLock;
    }

    @Nullable
    public Margin getMargin() {
        return this.margin;
    }

    @NonNull
    public ConstrainedSize getSize() {
        return this.size;
    }

    @Nullable
    public Position getPosition() {
        return this.position;
    }

    @Nullable
    public Color getShadeColor() {
        return this.shadeColor;
    }

    @Override
    public boolean shouldIgnoreSafeArea() {
        return this.ignoreSafeArea;
    }

    @Nullable
    public Border getBorder() {
        return this.border;
    }

    @Nullable
    public Color getBackgroundColor() {
        return this.backgroundColor;
    }
}

