/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.property;

import androidx.annotation.NonNull;
import com.urbanairship.android.layout.util.PercentUtils;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonMap;

public class Size {
    @NonNull
    private static final String SIZE_AUTO = "auto";
    @NonNull
    private final Dimension width;
    @NonNull
    private final Dimension height;

    public Size(@NonNull String width, @NonNull String height) {
        this.width = Dimension.of(width);
        this.height = Dimension.of(height);
    }

    @NonNull
    public static Size fromJson(@NonNull JsonMap json) throws JsonException {
        String width = json.opt("width").coerceString();
        String height = json.opt("height").coerceString();
        if (width == null || height == null) {
            throw new JsonException("Size requires both width and height!");
        }
        return new Size(width, height);
    }

    @NonNull
    public String toString() {
        return "Size { width=" + this.getWidth() + ", height=" + this.getHeight() + " }";
    }

    @NonNull
    public Dimension getWidth() {
        return this.width;
    }

    @NonNull
    public Dimension getHeight() {
        return this.height;
    }

    public static class AbsoluteDimension
    extends Dimension {
        AbsoluteDimension(@NonNull String value) {
            super(value, DimensionType.ABSOLUTE);
        }

        @Override
        public float getFloat() {
            return Float.parseFloat(this.value);
        }

        @Override
        public int getInt() {
            return (int)this.getFloat();
        }

        @NonNull
        public String toString() {
            return this.getInt() + "dp";
        }
    }

    public static class PercentDimension
    extends Dimension {
        PercentDimension(@NonNull String value) {
            super(value, DimensionType.PERCENT);
        }

        @Override
        public float getFloat() {
            return PercentUtils.parse(this.value);
        }

        @Override
        public int getInt() {
            return (int)this.getFloat();
        }

        @NonNull
        public String toString() {
            return (int)(this.getFloat() * 100.0f) + "%";
        }
    }

    public static class AutoDimension
    extends Dimension {
        AutoDimension() {
            super(Size.SIZE_AUTO, DimensionType.AUTO);
        }

        @Override
        public float getFloat() {
            return -1.0f;
        }

        @Override
        public int getInt() {
            return -1;
        }

        @NonNull
        public String toString() {
            return this.value;
        }
    }

    public static abstract class Dimension {
        @NonNull
        protected final String value;
        @NonNull
        private final DimensionType type;

        Dimension(@NonNull String value, @NonNull DimensionType type) {
            this.value = value;
            this.type = type;
        }

        @NonNull
        public static Dimension of(@NonNull String value) {
            if (value.equals(Size.SIZE_AUTO)) {
                return new AutoDimension();
            }
            if (PercentUtils.isPercent(value)) {
                return new PercentDimension(value);
            }
            return new AbsoluteDimension(value);
        }

        public abstract float getFloat();

        public abstract int getInt();

        @NonNull
        public DimensionType getType() {
            return this.type;
        }

        public boolean isAuto() {
            return this.type == DimensionType.AUTO;
        }

        public boolean isPercent() {
            return this.type == DimensionType.PERCENT;
        }

        public boolean isAbsolute() {
            return this.type == DimensionType.ABSOLUTE;
        }
    }

    public static enum DimensionType {
        AUTO,
        PERCENT,
        ABSOLUTE;

    }
}

