/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.property;

import androidx.annotation.NonNull;
import com.urbanairship.android.layout.property.CheckboxStyle;
import com.urbanairship.android.layout.property.SwitchStyle;
import com.urbanairship.android.layout.property.ToggleType;
import com.urbanairship.json.JsonException;
import com.urbanairship.json.JsonMap;

public abstract class ToggleStyle {
    @NonNull
    private final ToggleType type;

    ToggleStyle(@NonNull ToggleType type) {
        this.type = type;
    }

    @NonNull
    public static ToggleStyle fromJson(@NonNull JsonMap json) throws JsonException {
        String typeString = json.opt("type").optString();
        switch (ToggleType.from(typeString)) {
            case SWITCH: {
                return SwitchStyle.fromJson(json);
            }
            case CHECKBOX: {
                return CheckboxStyle.fromJson(json);
            }
        }
        throw new JsonException("Failed to parse ToggleStyle! Unknown type: " + typeString);
    }

    @NonNull
    public ToggleType getType() {
        return this.type;
    }
}

