/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.property;

import androidx.annotation.NonNull;
import com.urbanairship.json.JsonException;
import java.util.Locale;

public enum ToggleType {
    SWITCH("switch"),
    CHECKBOX("checkbox");

    @NonNull
    private final String value;

    private ToggleType(String value) {
        this.value = value;
    }

    @NonNull
    public static ToggleType from(@NonNull String value) throws JsonException {
        for (ToggleType type : ToggleType.values()) {
            if (!type.value.equals(value.toLowerCase(Locale.ROOT))) continue;
            return type;
        }
        throw new JsonException("Unknown ToggleType value: " + value);
    }

    @NonNull
    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }
}

