/*
 * Decompiled with CFR 0.152.
 */
package com.urbanairship.android.layout.property;

import androidx.annotation.NonNull;
import com.urbanairship.json.JsonException;
import java.util.Locale;

public enum VerticalPosition {
    TOP("top", 48),
    BOTTOM("bottom", 80),
    CENTER("center", 16);

    @NonNull
    private final String value;
    private final int gravity;

    private VerticalPosition(String value, int gravity) {
        this.value = value;
        this.gravity = gravity;
    }

    @NonNull
    public static VerticalPosition from(@NonNull String value) throws JsonException {
        for (VerticalPosition vp : VerticalPosition.values()) {
            if (!vp.value.equals(value.toLowerCase(Locale.ROOT))) continue;
            return vp;
        }
        throw new JsonException("Unknown VerticalPosition value: " + value);
    }

    public int getGravity() {
        return this.gravity;
    }

    @NonNull
    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }
}

